/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.region.ui;

import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.progress.UIJob;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.district.region.DiagramRegions;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.participant.Selection;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateRegionFromSelection {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateRegionFromSelection.class);

    @CanExecute
    public boolean canExecute(ESelectionService selectionService) {
        return selectionService.getSelection() != null;
    }

    @Execute
    public void createRegionFromSelection() {
        IEditorPart activeEditor = WorkbenchUtils.getActiveEditor();
        ICanvasContext context = (ICanvasContext)activeEditor.getAdapter(ICanvasContext.class);
        if (context != null) {
            IDiagram diagram = (IDiagram)activeEditor.getAdapter(IDiagram.class);
            if (diagram != null) {
                final Resource diagramResource = (Resource)diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE);
                Selection selection = (Selection)context.getAtMostOneItemOfClass(Selection.class);
                Set allSelections = selection.getAllSelections();
                Rectangle2D surroundingElementBoundsOnDiagram = ElementUtils.getSurroundingElementBoundsOnDiagram((Collection)allSelections);
                final double[] coordinates = DiagramRegions.shapeToCoordinates((Shape)surroundingElementBoundsOnDiagram);
                UIJob job = new UIJob("Creating new region for diagram"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        InputDialog d = new InputDialog(this.getDisplay().getActiveShell(), "Enter label for region", "Enter region label", "", null);
                        int status = d.open();
                        if (status == 0) {
                            final String label = d.getValue();
                            Simantics.getSession().asyncRequest(new Write(){

                                public void perform(WriteGraph graph) throws DatabaseException {
                                    DiagramRegions.createRegionForDiagram((WriteGraph)graph, (Resource)diagramResource, (String)label, (double[])coordinates);
                                }
                            });
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setUser(true);
                job.schedule();
            } else {
                LOGGER.warn("No diagram available for active editor {}", (Object)activeEditor);
            }
        } else {
            LOGGER.warn("No CanvasContext available for active editor {}", (Object)activeEditor);
        }
    }
}

