/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.profile;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.diagram.profile.StyleBase;
import org.simantics.district.network.profile.DiagramSettings;
import org.simantics.district.network.profile.DiagramSettingsRequest;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DSceneGraph;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;
import org.simantics.scenegraph.profile.EvaluationContext;
import org.simantics.scenegraph.profile.common.ProfileVariables;

public class VertexSizeStyle
extends StyleBase<Double> {
    private static final Double PENDING = Double.NaN;
    private static final Double ONE = 1.0;

    public Double calculateStyle(ReadGraph graph, Resource runtimeDiagram, Resource entry, Resource groupItem) throws DatabaseException {
        DiagramSettings ds = (DiagramSettings)graph.syncRequest((Read)new DiagramSettingsRequest(runtimeDiagram), (AsyncProcedure)TransientCacheAsyncListener.instance());
        Double scaling = ONE;
        if (ds.vertexScaleProperty.isPresent()) {
            scaling = (Double)Simantics.applySCLRead((ReadGraph)graph, ds.vertexScaleProperty.get(), (Object)groupItem);
            scaling = scaling == null ? ONE : Double.valueOf(scaling * ds.vertexScaleGain + ds.vertexScaleBias);
        }
        return scaling;
    }

    public void applyStyleForNode(EvaluationContext observer, INode node, Double value) {
        SingleElementNode n = (SingleElementNode)node;
        if (value == PENDING) {
            ((G2DSceneGraph)node.getRootNode()).setPending((Object)node);
        } else {
            ((G2DSceneGraph)node.getRootNode()).clearPending((Object)node);
        }
        if (value == null) {
            value = ONE;
        }
        for (INode nn : n.getNodes()) {
            ProfileVariables.claimNodeProperty((INode)nn, (String)"size", (Object)value, (EvaluationContext)observer);
        }
    }

    protected void cleanupStyleForNode(EvaluationContext evaluationContext, INode node) {
        ((G2DSceneGraph)node.getRootNode()).clearPending((Object)node);
        SingleElementNode n = (SingleElementNode)node;
        for (INode nn : n.getNodes()) {
            ProfileVariables.claimNodeProperty((INode)nn, (String)"size", (Object)ONE, (EvaluationContext)evaluationContext);
        }
    }
}

