/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.profile;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.OrderedSet;
import org.simantics.db.common.procedure.wrapper.SetListenerToSingleSetListener;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.procedure.SetListener;
import org.simantics.db.request.AsyncMultiRead;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.profile.Group;
import org.simantics.utils.strings.StringUtils;

public class DistrictNodeGroup
implements Group {
    private final String name;
    private final Collection<Resource> types;
    private final Set<String> mappedComponentTypeNames;

    public DistrictNodeGroup(ReadGraph graph, Resource group) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        this.name = StringUtils.safeString((String)((String)graph.getPossibleRelatedValue(group, L0.HasName, (Binding)Bindings.STRING)));
        this.types = graph.getObjects(group, DIA.TypeGroup_HasType);
        Collection names = graph.getObjects(group, DN.DistrictNodeGroup_hasComponentTypeName);
        this.mappedComponentTypeNames = new HashSet<String>(names.size());
        for (Resource name : names) {
            this.mappedComponentTypeNames.add((String)graph.getValue(name, (Binding)Bindings.STRING));
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.types.hashCode();
        result = 31 * result + this.mappedComponentTypeNames.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DistrictNodeGroup other = (DistrictNodeGroup)obj;
        return this.name.equals(other.name) && this.types.equals(other.types) && this.mappedComponentTypeNames.equals(other.mappedComponentTypeNames);
    }

    public void trackItems(RequestProcessor processor, Resource runtimeDiagram, SetListener<Resource> listener) throws DatabaseException {
        if (this.types.isEmpty()) {
            System.out.println("DistrictNodeGroup has no types!");
            return;
        }
        processor.syncRequest((Read)new TernaryRead<Resource, Collection<Resource>, Set<String>, Collection<Resource>>(runtimeDiagram, this.types, this.mappedComponentTypeNames){

            public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
                return (Collection)graph.syncRequest((Read)new ElementsMappedToComponentTypes((Resource)this.parameter, (Collection)this.parameter2, (Set)this.parameter3));
            }
        }, (Listener)new SetListenerToSingleSetListener(listener));
    }

    public String toString() {
        return "every '" + this.name + "' of mapped type " + this.mappedComponentTypeNames;
    }

    private static class ElementsMappedToComponentTypes
    extends TernaryRead<Resource, Collection<Resource>, Set<String>, Set<Resource>> {
        public ElementsMappedToComponentTypes(Resource runtimeDiagram, Collection<Resource> elementTypes, Set<String> componentTypeNames) {
            super((Object)runtimeDiagram, elementTypes, componentTypeNames);
        }

        public Set<Resource> perform(ReadGraph graph) throws DatabaseException {
            DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
            HashSet<Resource> result = new HashSet<Resource>();
            Set elementsOfType = (Set)graph.syncRequest((Read)new ElementsOfType((Resource)this.parameter, (Collection)this.parameter2));
            for (Resource e : elementsOfType) {
                String ct;
                Resource mapping = graph.getPossibleObject(e, DN.HasMapping);
                if (mapping == null || (ct = (String)graph.getPossibleRelatedValue(mapping, DN.Mapping_ComponentType, (Binding)Bindings.STRING)) == null || !((Set)this.parameter3).contains(ct)) continue;
                result.add(e);
            }
            return result;
        }
    }

    private static class ElementsOfType
    extends BinaryRead<Resource, Collection<Resource>, Set<Resource>> {
        public ElementsOfType(Resource runtimeDiagram, Collection<Resource> types) {
            super((Object)runtimeDiagram, types);
        }

        public Set<Resource> perform(ReadGraph graph) throws DatabaseException {
            HashSet<Resource> result = new HashSet<Resource>();
            Resource realDiagram = graph.getPossibleObject((Resource)this.parameter, DiagramResource.getInstance((ReadGraph)graph).RuntimeDiagram_HasConfiguration);
            if (realDiagram == null) {
                return result;
            }
            Collection elements = graph.syncRequest((AsyncMultiRead)new OrderedSet(realDiagram));
            for (Resource element : elements) {
                Set elementTypes = graph.getTypes(element);
                if (Collections.disjoint((Collection)this.parameter2, elementTypes)) continue;
                result.add(element);
            }
            return result;
        }
    }
}

