/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.profile;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.profile.DiagramSettings;
import org.simantics.scl.runtime.function.Function1;

public class DiagramSettingsRequest
extends ResourceRead<DiagramSettings> {
    public DiagramSettingsRequest(Resource runtimeDiagram) {
        super(runtimeDiagram);
    }

    public DiagramSettings perform(ReadGraph graph) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Function1 elementColoringFunction = null;
        float elementColoringGradientHue = 0.0f;
        float elementColoringGradientSaturation = 1.0f;
        Function1 edgeThicknessProperty = null;
        Function1 nodeScaleProperty = null;
        double edgeThicknessGain = 1.0;
        double edgeThicknessBias = 0.0;
        double nodeScaleGain = 1.0;
        double nodeScaleBias = 0.0;
        Resource diagram = graph.getPossibleObject(this.resource, DIA.RuntimeDiagram_HasConfiguration);
        if (diagram != null) {
            Resource nsp;
            Object obj;
            Variable dv = Variables.getPossibleVariable((ReadGraph)graph, (Resource)diagram);
            if (dv != null && (obj = dv.getPossiblePropertyValue(graph, DN.Diagram_elementColoringFunction)) instanceof Function1) {
                elementColoringFunction = (Function1)obj;
            }
            elementColoringGradientHue = DiagramSettingsRequest.limit(0.0f, 360.0f, DiagramSettingsRequest.safeFloatProperty(graph, diagram, DN.Diagram_elementColoringGradientHue, 0.0f)) / 360.0f;
            elementColoringGradientSaturation = DiagramSettingsRequest.limit(0.0f, 100.0f, DiagramSettingsRequest.safeFloatProperty(graph, diagram, DN.Diagram_elementColoringGradientSaturation, 0.0f)) / 100.0f;
            Resource etp = graph.getPossibleObject(diagram, DN.Diagram_edgeThicknessProperty);
            if (etp != null) {
                Variable etpv = Variables.getPossibleVariable((ReadGraph)graph, (Resource)etp);
                if (etpv != null) {
                    edgeThicknessProperty = (Function1)etpv.getPropertyValue(graph, DN.Edge_ThicknessProperty_value);
                }
                edgeThicknessGain = DiagramSettingsRequest.safeDoubleProperty(graph, etp, DN.Edge_ThicknessProperty_gain, 1.0) * DiagramSettingsRequest.safeDoubleProperty(graph, diagram, DN.Diagram_edgeThicknessGain, 1.0);
                edgeThicknessBias = DiagramSettingsRequest.safeDoubleProperty(graph, etp, DN.Edge_ThicknessProperty_bias, 0.0) + DiagramSettingsRequest.safeDoubleProperty(graph, diagram, DN.Diagram_edgeThicknessBias, 0.0);
            }
            if ((nsp = graph.getPossibleObject(diagram, DN.Diagram_nodeScaleProperty)) != null) {
                Variable nspv = Variables.getPossibleVariable((ReadGraph)graph, (Resource)nsp);
                if (nspv != null) {
                    nodeScaleProperty = (Function1)nspv.getPropertyValue(graph, DN.Vertex_ScaleProperty_value);
                }
                nodeScaleGain = DiagramSettingsRequest.safeDoubleProperty(graph, nsp, DN.Vertex_ScaleProperty_gain, 1.0) * DiagramSettingsRequest.safeDoubleProperty(graph, diagram, DN.Diagram_nodeScaleGain, 1.0);
                nodeScaleBias = DiagramSettingsRequest.safeDoubleProperty(graph, nsp, DN.Vertex_ScaleProperty_bias, 0.0) + DiagramSettingsRequest.safeDoubleProperty(graph, diagram, DN.Diagram_nodeScaleBias, 0.0);
            }
        }
        DiagramSettings ds = new DiagramSettings(nodeScaleProperty, nodeScaleGain, nodeScaleBias, edgeThicknessProperty, edgeThicknessGain, edgeThicknessBias, elementColoringFunction, elementColoringGradientHue, elementColoringGradientSaturation);
        return ds;
    }

    private static float safeFloatProperty(ReadGraph graph, Resource r, Resource property, float defaultValue) throws DatabaseException {
        Float d = (Float)graph.getPossibleRelatedValue(r, property, (Binding)Bindings.FLOAT);
        return d != null ? d.floatValue() : defaultValue;
    }

    private static double safeDoubleProperty(ReadGraph graph, Resource r, Resource property, double defaultValue) throws DatabaseException {
        Double d = (Double)graph.getPossibleRelatedValue(r, property, (Binding)Bindings.DOUBLE);
        return d != null ? d : defaultValue;
    }

    private static float limit(float min, float max, float value) {
        return Math.max(min, Math.min(value, max));
    }

    private static double limit(double min, double max, double value) {
        return Math.max(min, Math.min(value, max));
    }
}

