/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.profile;

import java.util.Optional;
import org.simantics.db.Resource;
import org.simantics.district.network.profile.ColorGradient;
import org.simantics.district.network.profile.Colors;
import org.simantics.scl.runtime.function.Function1;

public class DiagramSettings {
    public final Optional<Function1<Resource, Double>> vertexScaleProperty;
    public final double vertexScaleGain;
    public final double vertexScaleBias;
    public final Optional<Function1<Resource, Double>> edgeThicknessProperty;
    public final double edgeThicknessGain;
    public final double edgeThicknessBias;
    public final Optional<Function1<Resource, Double>> elementColoringFunction;
    public final float elementColoringGradientHue;
    public final float elementColoringGradientSaturation;
    public final transient ColorGradient coloringGradient;

    public DiagramSettings(Function1<Resource, Double> vertexScaleProperty, double vertexScaleGain, double vertexScaleBias, Function1<Resource, Double> edgeThicknessProperty, double edgeThicknessGain, double edgeThicknessBias, Function1<Resource, Double> elementColoringFunction, float elementColoringGradientHue, float elementColoringGradientSaturation) {
        this.vertexScaleProperty = Optional.ofNullable(vertexScaleProperty);
        this.vertexScaleGain = vertexScaleGain;
        this.vertexScaleBias = vertexScaleBias;
        this.edgeThicknessProperty = Optional.ofNullable(edgeThicknessProperty);
        this.edgeThicknessGain = edgeThicknessGain;
        this.edgeThicknessBias = edgeThicknessBias;
        this.elementColoringFunction = Optional.ofNullable(elementColoringFunction);
        this.elementColoringGradientHue = elementColoringGradientHue;
        this.elementColoringGradientSaturation = elementColoringGradientSaturation;
        this.coloringGradient = Colors.cached(Colors.hsvGradient(elementColoringGradientHue, elementColoringGradientSaturation));
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.edgeThicknessProperty.hashCode();
        long temp = Double.doubleToLongBits(this.edgeThicknessGain);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.edgeThicknessBias);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.vertexScaleProperty.hashCode();
        temp = Double.doubleToLongBits(this.vertexScaleGain);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.vertexScaleBias);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.elementColoringFunction.hashCode();
        result = 31 * result + Float.floatToIntBits(this.elementColoringGradientHue);
        result = 31 * result + Float.floatToIntBits(this.elementColoringGradientSaturation);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DiagramSettings other = (DiagramSettings)obj;
        if (!this.edgeThicknessProperty.equals(other.edgeThicknessProperty)) {
            return false;
        }
        if (Double.doubleToLongBits(this.edgeThicknessGain) != Double.doubleToLongBits(other.edgeThicknessGain)) {
            return false;
        }
        if (Double.doubleToLongBits(this.edgeThicknessBias) != Double.doubleToLongBits(other.edgeThicknessBias)) {
            return false;
        }
        if (!this.vertexScaleProperty.equals(other.vertexScaleProperty)) {
            return false;
        }
        if (Double.doubleToLongBits(this.vertexScaleGain) != Double.doubleToLongBits(other.vertexScaleGain)) {
            return false;
        }
        if (Double.doubleToLongBits(this.vertexScaleBias) != Double.doubleToLongBits(other.vertexScaleBias)) {
            return false;
        }
        if (!this.elementColoringFunction.equals(other.elementColoringFunction)) {
            return false;
        }
        if (Float.floatToIntBits(this.elementColoringGradientHue) != Float.floatToIntBits(other.elementColoringGradientHue)) {
            return false;
        }
        return Float.floatToIntBits(this.elementColoringGradientSaturation) == Float.floatToIntBits(other.elementColoringGradientSaturation);
    }

    public String toString() {
        return String.format("DiagramSettings[%s * %f + %f - %s * %f + %f - coloringFunction: %s, hue: %f, saturation: %f]", this.vertexScaleProperty.toString(), this.vertexScaleGain, this.vertexScaleBias, this.edgeThicknessProperty, this.edgeThicknessGain, this.edgeThicknessBias, this.elementColoringFunction.toString(), Float.valueOf(this.elementColoringGradientHue), Float.valueOf(this.elementColoringGradientSaturation));
    }
}

