/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.participants;

import java.awt.geom.Point2D;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.simantics.district.network.ui.adapters.DistrictNetworkEdgeElement;
import org.simantics.district.network.ui.adapters.DistrictNetworkVertexElement;
import org.simantics.district.network.ui.participants.DNTranslateMode;
import org.simantics.g2d.canvas.ICanvasParticipant;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.participant.pointertool.PointerInteractor;
import org.simantics.g2d.diagram.participant.pointertool.TerminalUtil;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.IElement;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.nodes.SingleElementNode;

public class DNPointerInteractor
extends PointerInteractor {
    public DNPointerInteractor() {
        super((PickRequest.PickSorter)new DNPickSorter());
    }

    protected ICanvasParticipant createConnectTool(TerminalUtil.TerminalInfo ti, int mouseId, Point2D startCanvasPos) {
        return super.createConnectTool(ti, mouseId, startCanvasPos);
    }

    protected ICanvasParticipant createTranslateTool(int mouseId, Point2D startCanvasPos, Point2D curCanvasPos, Set<IElement> elementsToDrag) {
        return new DNTranslateMode(startCanvasPos, curCanvasPos, mouseId, elementsToDrag);
    }

    private static class DNPickSorter
    implements PickRequest.PickSorter {
        private DNPickSorter() {
        }

        public void sort(List<IElement> elements) {
            Collections.sort(elements, (e1, e2) -> {
                IG2DNode e1node = DNPickSorter.getNode(e1);
                IG2DNode e2node = DNPickSorter.getNode(e2);
                if (e1node.getZIndex() < e2node.getZIndex()) {
                    return -1;
                }
                if (e1node.getZIndex() > e2node.getZIndex()) {
                    return 1;
                }
                return 0;
            });
        }

        private static IG2DNode getNode(IElement element) {
            IG2DNode node = (IG2DNode)element.getHint(DistrictNetworkEdgeElement.KEY_DN_EDGE_NODE);
            if (node == null) {
                node = (IG2DNode)element.getHint(DistrictNetworkVertexElement.KEY_DN_VERTEX_NODE);
            }
            if (node == null && (node = (IG2DNode)element.getHint(ElementHints.KEY_SG_NODE)) instanceof SingleElementNode) {
                SingleElementNode snode = (SingleElementNode)node;
                node = (IG2DNode)snode.getNodes().iterator().next();
            }
            return node;
        }
    }
}

