/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.nodes;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import org.simantics.district.network.ModelledCRS;
import org.simantics.district.network.ui.DistrictNetworkEdge;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.ISelectionPainterNode;
import org.simantics.scenegraph.g2d.G2DNode;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.scenegraph.utils.NodeUtil;

public class DistrictNetworkEdgeNode
extends G2DNode
implements ISelectionPainterNode {
    private static final long serialVersionUID = 8049769475036519806L;
    private static final BasicStroke STROKE = new BasicStroke(4.0f, 1, 1);
    private static final Color SELECTION_COLOR = new Color(255, 0, 255, 96);
    private DistrictNetworkEdge edge;
    private Rectangle2D bounds;
    private transient Line2D path;
    private boolean scaleStroke = true;
    private Color color;
    private Double stroke;
    private transient Color dynamicColor = null;

    public void init() {
    }

    public void render(Graphics2D g2d) {
        AffineTransform ot = null;
        AffineTransform t = this.getTransform();
        if (t != null && !t.isIdentity()) {
            ot = g2d.getTransform();
            g2d.transform(this.getTransform());
        }
        Object aaHint = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color oldColor = g2d.getColor();
        BasicStroke oldStroke = (BasicStroke)g2d.getStroke();
        BasicStroke bs = null;
        if (this.scaleStroke) {
            double scale = GeometryUtils.getScale((AffineTransform)g2d.getTransform());
            scale = Math.max(10000.0, Math.min(scale, 50000.0));
            double str = this.stroke != null ? Math.abs(this.stroke) : 1.0;
            bs = GeometryUtils.scaleStroke((Stroke)STROKE, (float)((float)(str / scale)));
        } else {
            bs = STROKE;
        }
        this.path = DistrictNetworkEdgeNode.calculateLine(this.edge, this.path);
        if (this.isSelected()) {
            g2d.setColor(SELECTION_COLOR);
            g2d.setStroke(GeometryUtils.scaleStroke((Stroke)bs, (float)4.0f));
            g2d.draw(this.path);
        }
        g2d.setColor(this.dynamicColor != null ? this.dynamicColor : this.color);
        g2d.setStroke(bs);
        g2d.draw(this.path);
        g2d.setStroke(oldStroke);
        g2d.setColor(oldColor);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaHint);
        if (ot != null) {
            g2d.setTransform(ot);
        }
    }

    public static Line2D calculateLine(DistrictNetworkEdge edge, Line2D result) {
        double startX = ModelledCRS.longitudeToX((double)edge.getStartPoint().getX());
        double startY = ModelledCRS.latitudeToY((double)(-edge.getStartPoint().getY()));
        double endX = ModelledCRS.longitudeToX((double)edge.getEndPoint().getX());
        double endY = ModelledCRS.latitudeToY((double)(-edge.getEndPoint().getY()));
        if (result == null) {
            result = new Line2D.Double();
        }
        result.setLine(startX, startY, endX, endY);
        return result;
    }

    public static Path2D calculatePath(DistrictNetworkEdge edge, Path2D result) {
        double startX = ModelledCRS.longitudeToX((double)edge.getStartPoint().getX());
        double startY = ModelledCRS.latitudeToY((double)(-edge.getStartPoint().getY()));
        double endX = ModelledCRS.longitudeToX((double)edge.getEndPoint().getX());
        double endY = ModelledCRS.latitudeToY((double)(-edge.getEndPoint().getY()));
        if (result == null) {
            result = new Path2D.Double();
        } else {
            result.reset();
        }
        result.moveTo(startX, startY);
        result.lineTo(endX, endY);
        return result;
    }

    private boolean isSelected() {
        return NodeUtil.isSelected((INode)this, (int)1);
    }

    public Rectangle2D getBoundsInLocal() {
        return this.bounds;
    }

    private void updateBounds() {
        Rectangle2D oldBounds = this.bounds;
        if (oldBounds == null) {
            oldBounds = new Rectangle2D.Double();
        }
        this.bounds = this.calculateBounds(oldBounds);
    }

    private Rectangle2D calculateBounds(Rectangle2D rect) {
        return DistrictNetworkEdgeNode.calculatePath(this.edge, null).getBounds2D();
    }

    public void setDNEdge(DistrictNetworkEdge edge) {
        this.edge = edge;
        this.updateBounds();
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    @INode.PropertySetter(value="stroke")
    public void setStroke(Double stroke) {
        this.stroke = stroke;
    }

    @INode.PropertySetter(value="dynamicColor")
    public void setDynamicColor(Color color) {
        this.dynamicColor = color;
    }
}

