/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui.contributions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.district.network.ui.function.Functions;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.ui.ISelectionUtils;

public class ChangeMappingTypeHandler {
    @CanExecute
    public boolean canExecute(@Named(value="org.eclipse.ui.selection") ISelection selection) {
        final List elements = ISelectionUtils.getPossibleKeys((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (elements.size() < 1) {
            return false;
        }
        try {
            return (Boolean)Simantics.getSession().syncRequest((Read)new Read<Boolean>(){

                public Boolean perform(ReadGraph graph) throws DatabaseException {
                    Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                    Resource instanceOf = null;
                    for (Resource element : elements) {
                        if (instanceOf == null) {
                            instanceOf = graph.getSingleObject(element, L0.InstanceOf);
                            continue;
                        }
                        Resource currentInstanceOf = graph.getSingleObject(element, L0.InstanceOf);
                        if (currentInstanceOf.equals(instanceOf)) continue;
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Execute
    public void execute(@Named(value="org.eclipse.ui.selection") Object selection) {
        final List elements = ISelectionUtils.getPossibleKeys((Object)selection, (IHintContext.Key)SelectionHints.KEY_MAIN, Resource.class);
        if (elements.size() < 1) {
            return;
        }
        SelectMappingDialog dialog = new SelectMappingDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), elements);
        if (dialog.open() != 0) {
            return;
        }
        final Resource mapping = dialog.getDefaultVertexMapping();
        DatabaseJob job = new DatabaseJob("Join selected vertices"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Simantics.getSession().syncRequest((Write)new WriteRequest(){

                        public void perform(WriteGraph graph) throws DatabaseException {
                            DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                            for (Resource element : elements) {
                                graph.deny(element, DN.HasMapping);
                                graph.claim(element, DN.HasMapping, mapping);
                            }
                        }
                    });
                }
                catch (DatabaseException e) {
                    return new Status(4, "org.simantics.district.network.ui", String.valueOf(this.getName()) + " failed.", (Throwable)e);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private static class SelectMappingDialog
    extends SelectionStatusDialog {
        private Combo vertexMappingCombo;
        private Composite composite;
        private List<Resource> elements;
        private Map<String, Resource> vertexMappings = new HashMap<String, Resource>();
        private Resource defaultVertexMapping;

        protected SelectMappingDialog(Shell parentShell, List<Resource> elements) {
            super(parentShell);
            this.elements = elements;
            this.setTitle("Select mappings for new DN diagram");
        }

        public Resource getDefaultVertexMapping() {
            return this.defaultVertexMapping;
        }

        protected Control createDialogArea(Composite parent) {
            this.composite = (Composite)super.createDialogArea(parent);
            this.createMappingsGroup(this.composite);
            Simantics.getSession().asyncRequest((Read)new ReadRequest(){

                public void run(ReadGraph graph) throws DatabaseException {
                    DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
                    Resource element = (Resource)elements.get(0);
                    if (graph.isInstanceOf(element, DN.Vertex)) {
                        vertexMappings = Functions.getVertexMappings(graph, element);
                    } else if (graph.isInstanceOf(element, DN.Edge)) {
                        vertexMappings = Functions.getEdgeMappings(graph, element);
                    }
                    composite.getDisplay().asyncExec(() -> {
                        vertexMappingCombo.setItems(vertexMappings.keySet().toArray(new String[vertexMappings.size()]));
                        vertexMappingCombo.select(0);
                    });
                }
            });
            return this.composite;
        }

        protected void computeResult() {
            this.defaultVertexMapping = this.vertexMappings.get(this.vertexMappingCombo.getItem(this.vertexMappingCombo.getSelectionIndex()));
        }

        private void createMappingsGroup(Composite parent) {
            Group group = new Group(parent, 0);
            group.setFont(parent.getFont());
            group.setText("Default mappings");
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)group);
            group.setLayout((Layout)new GridLayout(1, false));
            Composite cmposite = new Composite((Composite)group, 0);
            cmposite.setLayoutData((Object)new GridData(4, 128, true, false));
            cmposite.setLayout((Layout)new GridLayout(2, false));
            Label vertexMappingLabel = new Label(cmposite, 0);
            vertexMappingLabel.setText("Default vertex mapping");
            this.vertexMappingCombo = new Combo(cmposite, 2056);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.vertexMappingCombo);
        }
    }
}

