/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui;

import org.simantics.g2d.participant.PanZoomRotateHandler;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.nodes.NavigationNode;

public class DistrictPanZoomRotateHandler
extends PanZoomRotateHandler {
    protected Class<? extends NavigationNode> getNavigationNodeClass() {
        return DistrictNavigationNode.class;
    }

    public static class DistrictNavigationNode
    extends NavigationNode {
        private static final long serialVersionUID = 5452897272925816875L;

        public Double getZoomInLimit() {
            return super.getZoomInLimit();
        }

        public Double getZoomOutLimit() {
            return super.getZoomOutLimit();
        }

        public boolean mouseWheelMoved(MouseEvent.MouseWheelMovedEvent me) {
            if (this.navigationEnabled.booleanValue() && this.zoomEnabled.booleanValue()) {
                double scroll = Math.min(0.9, (double)(-me.wheelRotation) / 20.0);
                double z = 1.0 - scroll;
                double dx = (me.controlPosition.getX() - this.transform.getTranslateX()) / this.transform.getScaleX();
                double dy = (me.controlPosition.getY() - this.transform.getTranslateY()) / this.transform.getScaleY();
                dx *= 1.0 - z;
                dy *= 1.0 - z;
                double limitedScale = this.limitScaleFactor(z);
                if (limitedScale != 1.0) {
                    this.translate(dx, dy);
                    this.scale(z, z);
                    this.transformChanged();
                    this.dropQuality();
                    this.repaint();
                }
            }
            return false;
        }
    }
}

