/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.EntityRemover;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.layer0.utils.binaryPredicates.OrderedSetElementsPredicate;
import org.simantics.modeling.adapters.ElementRemover;

public class DNElementRemover
extends ElementRemover {
    public DNElementRemover(Resource element) {
        super(element);
    }

    public void removeConnection(WriteGraph graph) throws DatabaseException {
        throw new UnsupportedOperationException("Distrct network should not have STR.Connection resources! " + this.resource);
    }

    public void removeElement(WriteGraph graph) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        if (graph.isInstanceOf(this.resource, DN.Vertex)) {
            graph.getObjects(this.resource, DN.HasEndVertex_Inverse).forEach(res -> {
                try {
                    DNElementRemover.doRemove(graph, res);
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
            });
            graph.getObjects(this.resource, DN.HasStartVertex_Inverse).forEach(res -> {
                try {
                    DNElementRemover.doRemove(graph, res);
                }
                catch (DatabaseException e) {
                    e.printStackTrace();
                }
            });
        }
        DNElementRemover.doRemove(graph, this.resource);
    }

    private static void doRemove(WriteGraph graph, Resource resource) throws DatabaseException {
        for (Resource diagram : OrderedSetElementsPredicate.INSTANCE.getSubjects((ReadGraph)graph, resource)) {
            OrderedSetUtils.remove((WriteGraph)graph, (Resource)diagram, (Resource)resource);
        }
        EntityRemover.remove((WriteGraph)graph, (Resource)resource);
    }
}

