/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.network.ui;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.BindingException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ManyObjectsForFunctionalRelationException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.request.Read;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.synchronization.IModifiableSynchronizationContext;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.GraphSynchronizationHints;
import org.simantics.diagram.synchronization.graph.layer.GraphLayerManager;
import org.simantics.district.network.DistrictNetworkUtil;
import org.simantics.district.network.ontology.DistrictNetworkResource;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.layer0.Layer0;

public class DNEdgeBuilder {
    private Resource diagramResource;
    private IDiagram diagram;
    private GraphLayerManager glm;

    public DNEdgeBuilder(Resource diagramResource, IDiagram diagram) {
        this.diagramResource = diagramResource;
        this.diagram = diagram;
        IModifiableSynchronizationContext context = (IModifiableSynchronizationContext)diagram.getHint(SynchronizationHints.CONTEXT);
        this.glm = (GraphLayerManager)context.get(GraphSynchronizationHints.GRAPH_LAYER_MANAGER);
    }

    public static Resource create(WriteGraph graph, Resource diagramResource, double[] start, double[] end, double padding) throws DatabaseException {
        Collection vertices = (Collection)graph.syncRequest((Read)new ObjectsWithType(diagramResource, Layer0.getInstance((ReadGraph)graph).ConsistsOf, DistrictNetworkResource.getInstance((ReadGraph)graph).Vertex));
        ArrayList<ResourceVertex> vv = new ArrayList<ResourceVertex>(vertices.size());
        for (Resource vertex : vertices) {
            double[] existingCoords = (double[])graph.getRelatedValue2(vertex, DiagramResource.getInstance((ReadGraph)graph).HasLocation, (Binding)Bindings.DOUBLE_ARRAY);
            vv.add(new ResourceVertex(vertex, existingCoords));
        }
        return DNEdgeBuilder.create(graph, vv, diagramResource, null, start, end, padding, false);
    }

    public static Resource create(WriteGraph graph, Collection<ResourceVertex> vertices, Resource diagramResource, Resource mapping, double[] start, double[] end, double padding, boolean writeElevationToEdgeFromPoints) throws DatabaseException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Resource edge = DNEdgeBuilder.getOrCreateEdge(graph, diagramResource, mapping);
        Resource startVertex = DNEdgeBuilder.getOrCreateVertex(graph, diagramResource, vertices, start, padding, null);
        Resource endVertex = DNEdgeBuilder.getOrCreateVertex(graph, diagramResource, vertices, end, padding, startVertex);
        if (writeElevationToEdgeFromPoints) {
            graph.claimLiteral(edge, DN.Edge_HasElevation, (Object)DNEdgeBuilder.calculateElevationFromVertices(graph, startVertex, endVertex), (Binding)Bindings.DOUBLE);
        }
        graph.claim(edge, DN.HasStartVertex, startVertex);
        graph.claim(edge, DN.HasEndVertex, endVertex);
        return edge;
    }

    private static double calculateElevationFromVertices(WriteGraph graph, Resource startVertex, Resource endVertex) throws ManyObjectsForFunctionalRelationException, BindingException, ServiceException {
        DistrictNetworkResource DN = DistrictNetworkResource.getInstance((ReadGraph)graph);
        Double startElevation = (Double)graph.getPossibleRelatedValue(startVertex, DN.Vertex_HasElevation, (Binding)Bindings.DOUBLE);
        Double endElevation = (Double)graph.getPossibleRelatedValue(endVertex, DN.Vertex_HasElevation, (Binding)Bindings.DOUBLE);
        if (startElevation != null && endElevation != null) {
            return (startElevation + endElevation) / 2.0;
        }
        return 0.0;
    }

    public void create(WriteGraph graph, double[] start, double[] end, double padding) throws DatabaseException {
        Resource edge = DNEdgeBuilder.create(graph, this.diagramResource, start, end, padding);
        if (this.glm != null) {
            this.putOnActiveLayer(graph, edge);
        }
        Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Added edge " + edge));
        graph.markUndoPoint();
    }

    private void putOnActiveLayer(WriteGraph graph, Resource res) throws DatabaseException {
        this.glm.removeFromAllLayers(graph, res);
        this.glm.putElementOnVisibleLayers(this.diagram, graph, res);
    }

    private static Resource getOrCreateVertex(WriteGraph graph, Resource diagramResource, Collection<ResourceVertex> vertices, double[] coords, double padding, Resource startVertex) throws DatabaseException {
        Resource vertex = null;
        double halfPadding = padding / 2.0;
        double maxDistance = Double.MAX_VALUE;
        for (ResourceVertex vertx : vertices) {
            double dist;
            Rectangle2D.Double existing = new Rectangle2D.Double(vertx.coords[0] - halfPadding, vertx.coords[1] - halfPadding, padding, padding);
            Rectangle2D.Double tobecreated = new Rectangle2D.Double(coords[0] - halfPadding, coords[1] - halfPadding, padding, padding);
            if (!existing.intersects(tobecreated) || !((dist = Math.sqrt(Math.pow(coords[0] - vertx.coords[0], 2.0) + Math.pow(coords[1] - vertx.coords[1], 2.0))) <= maxDistance) || vertx.vertex.equals(startVertex)) continue;
            vertex = vertx.vertex;
            maxDistance = dist;
        }
        if (vertex == null) {
            vertex = DistrictNetworkUtil.createVertex((WriteGraph)graph, (Resource)diagramResource, (double[])coords);
            vertices.add(new ResourceVertex(vertex, coords));
        }
        return vertex;
    }

    private static Resource getOrCreateEdge(WriteGraph graph, Resource diagramResource, Resource mapping) throws DatabaseException {
        return DistrictNetworkUtil.createEdge((WriteGraph)graph, (Resource)diagramResource, (Resource)mapping);
    }

    public static class ResourceVertex {
        final Resource vertex;
        final double[] coords;

        public ResourceVertex(Resource vertex, double[] coords) {
            this.vertex = vertex;
            this.coords = coords;
        }
    }
}

