/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.pojo;

import java.awt.Image;
import org.simantics.maps.pojo.TileJob;
import org.simantics.maps.query.IQueryListener;
import org.simantics.maps.query.Query;
import org.simantics.maps.tile.IFilter;
import org.simantics.maps.tile.ITileJobQueue;
import org.simantics.maps.tile.ITileListener;
import org.simantics.maps.tile.ITileProvider;
import org.simantics.maps.tile.TileKey;

public class TileJobQueue
implements ITileJobQueue {
    private TileJob job;

    @Override
    public void setTileProvider(ITileProvider provider) {
        this.getJob().setTileProvider(provider);
    }

    public synchronized TileJob getJob() {
        if (this.job == null) {
            this.job = new TileJob();
        }
        return this.job;
    }

    @Override
    public void addJob(final TileKey key, final ITileListener listener) {
        this.getJob().addJob(new Query<TileKey, Image>(key, new IQueryListener<TileKey, Image>(){

            @Override
            public void queryCanceled(Query<TileKey, Image> job) {
                listener.tileCanceled(key);
            }

            @Override
            public void queryFailed(Query<TileKey, Image> job, Exception error) {
                listener.tileFailed(key, error);
            }

            @Override
            public void queryComplete(Query<TileKey, Image> job, Image result) {
                listener.tileUpdated(key, result);
            }
        }));
    }

    @Override
    public void filterQueries(IFilter<TileKey> filter) {
        this.getJob().filterQueries(filter);
    }

    public void addAsFirstJob(Query<TileKey, Image> job) {
        this.getJob().addAsFirstJob(job);
    }

    public void removeJob(Query<TileKey, Image> job) {
        this.getJob().removeJob(job);
    }
}

