/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.pojo;

import java.awt.Image;
import java.util.LinkedList;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.simantics.maps.ProvisionException;
import org.simantics.maps.query.Query;
import org.simantics.maps.tile.IFilter;
import org.simantics.maps.tile.ITileProvider;
import org.simantics.maps.tile.TileKey;

public class TileJob
implements Runnable {
    LinkedList<Query<TileKey, Image>> queue = new LinkedList();
    Executor executor = new ScheduledThreadPoolExecutor(1);
    ITileProvider provider;

    public void setTileProvider(ITileProvider provider) {
        this.provider = provider;
    }

    protected Image doQuery(TileKey key) throws ProvisionException {
        return this.provider.get(key);
    }

    @Override
    public void run() {
        Query<TileKey, Image> job = this.pullNextJob();
        do {
            if (job == null) continue;
            try {
                Image result = this.doQuery((TileKey)job.source);
                job.listener.queryComplete(job, result);
            }
            catch (Exception e) {
                job.listener.queryFailed(job, e);
            }
        } while ((job = this.pullNextJob()) != null);
    }

    protected synchronized int jobsLeft() {
        return this.queue.size();
    }

    protected synchronized Query<TileKey, Image> pullNextJob() {
        if (this.queue.isEmpty()) {
            return null;
        }
        return this.queue.removeFirst();
    }

    public synchronized void clear() {
        Query[] jobs;
        Query[] queryArray = jobs = this.queue.toArray(new Query[this.queue.size()]);
        int n = jobs.length;
        int n2 = 0;
        while (n2 < n) {
            Query j = queryArray[n2];
            this.removeJob(j);
            ++n2;
        }
    }

    public synchronized void addJob(Query<TileKey, Image> job) {
        this.queue.addLast(job);
        if (this.queue.size() == 1) {
            this.executor.execute(this);
        }
    }

    public synchronized void addAsFirstJob(Query<TileKey, Image> job) {
        this.queue.addFirst(job);
        if (this.queue.size() == 1) {
            this.executor.execute(this);
        }
    }

    public synchronized boolean removeJob(Query<TileKey, Image> job) {
        if (this.queue.remove(job)) {
            job.listener.queryCanceled(job);
            return true;
        }
        return false;
    }

    public synchronized void filterQueries(IFilter<TileKey> filter) {
        if (this.queue.isEmpty()) {
            return;
        }
        LinkedList<Query> result = new LinkedList<Query>();
        for (Query query : this.queue) {
            if (filter.select((TileKey)query.source)) {
                result.add(query);
                continue;
            }
            query.listener.queryCanceled(query);
        }
        this.queue = result;
    }
}

