/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.internal;

import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class ImageUtil {
    public static BufferedImage createScreenCompatibleImage(int width, int height, int transparency) {
        return ImageUtil.createCompatibleImage(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration(), width, height, transparency);
    }

    public static BufferedImage createCompatibleImage(GraphicsConfiguration conf, int width, int height, int transparency) {
        return conf.createCompatibleImage(width, height, transparency);
    }

    public static BufferedImage toScreenCompatibleImage(BufferedImage img) {
        return ImageUtil.toCompatibleImage(GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration(), img);
    }

    public static BufferedImage toCompatibleImage(GraphicsConfiguration conf, BufferedImage img) {
        if (img.getColorModel().equals(conf.getColorModel())) {
            return img;
        }
        BufferedImage result = ImageUtil.createCompatibleImage(conf, img.getWidth(), img.getHeight(), img.getTransparency());
        Graphics2D g = result.createGraphics();
        try {
            g.drawImage((Image)img, 0, 0, null);
            BufferedImage bufferedImage = result;
            return bufferedImage;
        }
        finally {
            g.dispose();
        }
    }
}

