/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.maps.eclipse;

import java.awt.Image;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.simantics.maps.eclipse.TileJob;
import org.simantics.maps.query.IQueryListener;
import org.simantics.maps.query.Query;
import org.simantics.maps.tile.IFilter;
import org.simantics.maps.tile.ITileJobQueue;
import org.simantics.maps.tile.ITileListener;
import org.simantics.maps.tile.ITileProvider;
import org.simantics.maps.tile.TileKey;

public class TileJobQueue
implements ITileJobQueue {
    private ITileProvider provider;
    private Map<TileKey, TileJob> queries = new Hashtable<TileKey, TileJob>();

    @Override
    public void setTileProvider(ITileProvider provider) {
        this.provider = provider;
    }

    public void addJob(Query<TileKey, Image> job) {
        TileJob tj = new TileJob(job, this.provider);
        this.queries.put((TileKey)job.source, tj);
        tj.schedule();
    }

    public void addAsFirstJob(Query<TileKey, Image> job) {
        TileJob tj = new TileJob(job, this.provider);
        this.queries.put((TileKey)job.source, tj);
        tj.schedule();
    }

    public void removeJob(Query<TileKey, Image> job) {
        TileJob t = this.queries.remove(job.source);
        if (t != null) {
            t.cancel();
        }
    }

    @Override
    public void addJob(final TileKey key, final ITileListener listener) {
        this.addJob(new Query<TileKey, Image>(key, new IQueryListener<TileKey, Image>(){

            @Override
            public void queryCanceled(Query<TileKey, Image> job) {
                listener.tileCanceled(key);
            }

            @Override
            public void queryFailed(Query<TileKey, Image> job, Exception error) {
                listener.tileFailed(key, error);
            }

            @Override
            public void queryComplete(Query<TileKey, Image> job, Image result) {
                listener.tileUpdated(key, result);
            }
        }));
    }

    @Override
    public void filterQueries(IFilter<TileKey> filter) {
        HashSet<TileKey> keys = new HashSet<TileKey>(this.queries.keySet());
        for (TileKey key : keys) {
            TileJob t;
            if (filter.select(key) || (t = this.queries.remove(key)) == null) continue;
            t.cancel();
            t.getQuery().listener.queryCanceled(t.getQuery());
        }
    }
}

