/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.district.imports;

import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.simantics.db.Resource;

public class DistrictImportUtils {
    private DistrictImportUtils() {
    }

    public static Resource importCSVAsLayer(Path csvFile) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (CSVParser parser = CSVFormat.DEFAULT.withFirstRecordAsHeader().parse((Reader)Files.newBufferedReader(csvFile));){
            Map header = parser.getHeaderMap();
            System.out.println(header);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    public static Map<String, Integer> readCSVHeader(Path source, char delimiter, boolean firstAsHeader) throws IOException {
        return DistrictImportUtils.readCSVHeader(source, CSVFormat.newFormat((char)delimiter), firstAsHeader);
    }

    public static Map<String, Integer> readCSVHeader(Path source, CSVFormat format, boolean firstAsHeader) throws IOException {
        if (firstAsHeader) {
            format = format.withFirstRecordAsHeader();
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (CSVParser parser = format.parse((Reader)Files.newBufferedReader(source));){
            return parser.getHeaderMap();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static Map<String, Character> getSupportedCSVDelimiterFormats() {
        HashMap<String, Character> delimiters = new HashMap<String, Character>();
        delimiters.put("Comma", Character.valueOf(','));
        delimiters.put("Semicolon", Character.valueOf(';'));
        delimiters.put("Tabulator", Character.valueOf('\t'));
        return delimiters;
    }

    public static List<Map<String, String>> readRows(Path source, char delimiter, boolean firstAsHeader, int amount) throws IOException {
        return DistrictImportUtils.readRows(source, CSVFormat.newFormat((char)delimiter), firstAsHeader, amount);
    }

    public static List<Map<String, String>> readRows(Path source, CSVFormat format, boolean firstAsHeader, int amount) throws IOException {
        if (firstAsHeader) {
            format = format.withFirstRecordAsHeader();
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (CSVParser parser = format.parse((Reader)Files.newBufferedReader(source));){
            int start = 0;
            ArrayList<Map<String, String>> results = new ArrayList<Map<String, String>>(amount);
            Iterator iter = parser.iterator();
            while (start < amount && iter.hasNext()) {
                CSVRecord record = (CSVRecord)iter.next();
                results.add(record.toMap());
                ++start;
            }
            return results;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static List<CSVRecord> readRows(Path source, char delim, int rowAmount) throws IOException {
        block11: {
            results = new ArrayList<CSVRecord>();
            format = CSVFormat.newFormat((char)delim);
            var5_5 = null;
            var6_7 = null;
            try {
                parser = format.parse((Reader)Files.newBufferedReader(source));
                try {
                    records = parser.iterator();
                    rows = 0;
                    if (rowAmount != -1) ** GOTO lbl20
                    while (records.hasNext()) {
                        results.add((CSVRecord)records.next());
                        ++rows;
                    }
                    break block11;
lbl-1000:
                    // 1 sources

                    {
                        results.add((CSVRecord)records.next());
                        ++rows;
lbl20:
                        // 2 sources

                        ** while (rows < rowAmount && records.hasNext())
                    }
lbl21:
                    // 1 sources

                }
                finally {
                    if (parser != null) {
                        parser.close();
                    }
                }
            }
            catch (Throwable var6_8) {
                if (var5_5 == null) {
                    var5_5 = var6_8;
                } else if (var5_5 != var6_8) {
                    var5_5.addSuppressed(var6_8);
                }
                throw var5_5;
            }
        }
        return results;
    }

    public static Map<CSVHeader, List<String>> readCSVHeaderAndRows(Path source, char delimiter, boolean firstAsHeader, int amount) throws IOException {
        HashMap<CSVHeader, List<String>> results = new HashMap<CSVHeader, List<String>>();
        CSVFormat format = CSVFormat.newFormat((char)delimiter);
        if (firstAsHeader) {
            format = format.withFirstRecordAsHeader();
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try (CSVParser parser = format.parse((Reader)Files.newBufferedReader(source));){
            Map headers = parser.getHeaderMap();
            if (headers != null && !headers.isEmpty()) {
                int index = 0;
                while (index < headers.size()) {
                    for (String head : headers.keySet()) {
                        results.put(new CSVHeader(head, index), new ArrayList());
                    }
                    ++index;
                }
            }
            Iterator records = parser.iterator();
            int rows = 0;
            while (rows < amount && records.hasNext()) {
                CSVRecord record = (CSVRecord)records.next();
                int j = 0;
                while (j < record.size()) {
                    String value = record.get(j);
                    String header = Integer.toString(j);
                    CSVHeader csvHeader = new CSVHeader(header, j);
                    ArrayList<String> vals = (ArrayList<String>)results.get(csvHeader);
                    if (vals == null) {
                        vals = new ArrayList<String>();
                        results.put(csvHeader, vals);
                    }
                    vals.add(value);
                    ++j;
                }
                ++rows;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return results;
    }

    public static Collection<String> readDistinctValuesOfColumn(Path source, char delim, int mappingIndex) throws IOException {
        HashSet<String> results = new HashSet<String>();
        CSVFormat format = CSVFormat.newFormat((char)delim);
        Throwable throwable = null;
        Object var6_7 = null;
        try (CSVParser parser = format.parse((Reader)Files.newBufferedReader(source));){
            Iterator records = parser.iterator();
            if (records.hasNext()) {
                records.next();
            }
            while (records.hasNext()) {
                CSVRecord row = (CSVRecord)records.next();
                String value = row.get(mappingIndex);
                results.add(value);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return results;
    }

    public static class CSVHeader {
        private final String header;
        private final int index;

        public CSVHeader(String header, int index) {
            this.header = header;
            this.index = index;
        }

        public String getHeader() {
            return this.header;
        }

        public int getIndex() {
            return this.index;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.header == null ? 0 : this.header.hashCode());
            result = 31 * result + this.index;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CSVHeader other = (CSVHeader)obj;
            if (this.header == null ? other.header != null : !this.header.equals(other.header)) {
                return false;
            }
            return this.index == other.index;
        }
    }
}

