/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.pgroup;

import org.eclipse.nebula.widgets.pgroup.AbstractGroupStrategy;
import org.eclipse.nebula.widgets.pgroup.AbstractToolItemRenderer;
import org.eclipse.nebula.widgets.pgroup.PGroup;
import org.eclipse.nebula.widgets.pgroup.PGroupToolItem;
import org.eclipse.nebula.widgets.pgroup.internal.GraphicUtils;
import org.eclipse.nebula.widgets.pgroup.internal.TextUtils;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;

public class RectangleGroupStrategy
extends AbstractGroupStrategy {
    private int vMargin = 2;
    private int hMargin = 5;
    private int titleTextMargin = 2;
    private int betweenSpacing = 4;
    private int margin = 1;
    private Color[] gradientColors = null;
    private int[] gradientPercents = null;
    private boolean gradientVertical = false;
    private Color borderColor = null;
    private Color g1;
    private Color g2;
    private int titleHeight;
    private int fontHeight;
    private int titleAreaHeight;
    private Rectangle toolItemArea;

    public void initialize(PGroup sg) {
        super.initialize(sg);
        this.getGroup().setForeground(this.getGroup().getDisplay().getSystemColor(30));
        this.g1 = this.getGroup().getDisplay().getSystemColor(32);
        this.g2 = this.getGroup().getDisplay().getSystemColor(31);
        this.setBackground(new Color[]{this.g1, this.g2}, new int[]{100}, true);
        this.setBorderColor(this.g2);
    }

    public void paint(GC gc) {
        Region reg;
        Color back;
        Point imagePoint = new Point(0, 0);
        Image image = this.getGroup().getImage();
        if (this.getGroup().getToggleRenderer() != null) {
            Point p = this.getGroup().getToggleRenderer().getSize();
            int toggleY = 0;
            toggleY = (this.getGroup().getImagePosition() & 0x80) == 0 ? (this.titleHeight - p.y) / 2 : this.titleHeight - this.titleAreaHeight + (this.titleAreaHeight - p.y) / 2;
            if ((this.getGroup().getTogglePosition() & 0x4000) != 0) {
                this.getGroup().getToggleRenderer().setLocation(new Point(this.hMargin, toggleY));
            } else {
                this.getGroup().getToggleRenderer().setLocation(new Point(this.getGroup().getSize().x - this.hMargin - p.x, toggleY));
            }
        }
        if ((back = this.getGroup().internalGetBackground()) != null) {
            gc.fillRectangle(0, 0, this.getGroup().getSize().x, this.getGroup().getSize().y);
            int yOffset = 0;
            if ((this.getGroup().getImagePosition() & 0x80) != 0 && image != null) {
                yOffset = this.titleHeight - this.titleAreaHeight;
            }
            reg = new Region();
            reg.add(0, yOffset + 0, 5, 1);
            reg.add(0, yOffset + 1, 3, 1);
            reg.add(0, yOffset + 2, 2, 1);
            reg.add(0, yOffset + 3, 1, 1);
            reg.add(0, yOffset + 4, 1, 1);
            reg.add(this.getGroup().getSize().x - 5, yOffset + 0, 5, 1);
            reg.add(this.getGroup().getSize().x - 3, yOffset + 1, 3, 1);
            reg.add(this.getGroup().getSize().x - 2, yOffset + 2, 2, 1);
            reg.add(this.getGroup().getSize().x - 1, yOffset + 3, 1, 1);
            reg.add(this.getGroup().getSize().x - 1, yOffset + 4, 1, 1);
            int height = this.getGroup().getSize().y;
            if (!this.getGroup().getExpanded()) {
                height = this.titleHeight;
            }
            reg.add(0, height - 1, 5, 1);
            reg.add(0, height - 2, 3, 1);
            reg.add(0, height - 3, 2, 1);
            reg.add(0, height - 4, 1, 1);
            reg.add(0, height - 5, 1, 1);
            reg.add(this.getGroup().getSize().x - 5, height - 1, 5, 1);
            reg.add(this.getGroup().getSize().x - 3, height - 2, 3, 1);
            reg.add(this.getGroup().getSize().x - 2, height - 3, 2, 1);
            reg.add(this.getGroup().getSize().x - 1, height - 4, 1, 1);
            reg.add(this.getGroup().getSize().x - 1, height - 5, 1, 1);
            if (yOffset != 0) {
                reg.add(0, 0, this.getGroup().getSize().x, yOffset);
            }
            if (!this.getGroup().getExpanded()) {
                int regionHeight = this.getGroup().getSize().y - this.titleHeight;
                if (regionHeight < 0) {
                    regionHeight = 0;
                }
                reg.add(new Rectangle(0, this.titleHeight, this.getGroup().getSize().x, regionHeight));
            }
            gc.setClipping(reg);
            this.getGroup().drawBackground(gc, 0, 0, this.getGroup().getSize().x, this.getGroup().getSize().y);
            gc.setClipping(null);
            reg.dispose();
        }
        int toggleHeight = 0;
        if (this.getGroup().getToggleRenderer() != null) {
            toggleHeight = this.getGroup().getToggleRenderer().getSize().y + 2 * this.vMargin;
        }
        reg = null;
        if ((this.getGroup().getStyle() & 0x10000) != 0) {
            reg = new Region((Device)this.getGroup().getDisplay());
            reg.add(0, 0, this.getGroup().getSize().x, this.titleHeight);
            int yOffset = 0;
            if ((this.getGroup().getImagePosition() & 0x80) != 0 && image != null) {
                yOffset = this.titleHeight - this.titleAreaHeight;
            }
            reg.subtract(0, yOffset + 0, 5, 1);
            reg.subtract(0, yOffset + 1, 3, 1);
            reg.subtract(0, yOffset + 2, 2, 1);
            reg.subtract(0, yOffset + 3, 1, 1);
            reg.subtract(0, yOffset + 4, 1, 1);
            reg.subtract(this.getGroup().getSize().x - 5, yOffset + 0, 5, 1);
            reg.subtract(this.getGroup().getSize().x - 3, yOffset + 1, 3, 1);
            reg.subtract(this.getGroup().getSize().x - 2, yOffset + 2, 2, 1);
            reg.subtract(this.getGroup().getSize().x - 1, yOffset + 3, 1, 1);
            reg.subtract(this.getGroup().getSize().x - 1, yOffset + 4, 1, 1);
            if (!this.getGroup().getExpanded()) {
                yOffset = this.titleHeight;
                reg.subtract(0, yOffset - 1, 5, 1);
                reg.subtract(0, yOffset - 2, 3, 1);
                reg.subtract(0, yOffset - 3, 2, 1);
                reg.subtract(0, yOffset - 4, 1, 1);
                reg.subtract(0, yOffset - 5, 1, 1);
                reg.subtract(this.getGroup().getSize().x - 5, yOffset - 1, 5, 1);
                reg.subtract(this.getGroup().getSize().x - 3, yOffset - 2, 3, 1);
                reg.subtract(this.getGroup().getSize().x - 2, yOffset - 3, 2, 1);
                reg.subtract(this.getGroup().getSize().x - 1, yOffset - 4, 1, 1);
                reg.subtract(this.getGroup().getSize().x - 1, yOffset - 5, 1, 1);
            }
            gc.setClipping(reg);
        }
        if ((this.getGroup().getImagePosition() & 0x80) == 0 || image == null) {
            if (this.gradientColors != null) {
                GraphicUtils.fillGradientRectangle(gc, 0, 0, this.getGroup().getSize().x, Math.max(this.titleHeight, toggleHeight), this.gradientColors, this.gradientPercents, this.gradientVertical);
            } else {
                gc.fillRectangle(0, 0, this.getGroup().getSize().x, Math.max(this.titleHeight, toggleHeight));
                GraphicUtils.fillRoundRectangle(gc, 0, 0, this.getGroup().getSize().x, Math.max(this.titleHeight, toggleHeight), null, true, !this.getGroup().getExpanded());
            }
            if ((this.getGroup().getStyle() & 0x10000) != 0) {
                GraphicUtils.drawRoundRectangle(gc, 0, 0, this.getGroup().getSize().x, Math.max(this.titleHeight, toggleHeight), null, null, true, !this.getGroup().getExpanded());
            }
        } else if (this.gradientColors != null) {
            GraphicUtils.fillGradientRectangle(gc, 0, this.titleHeight - this.titleAreaHeight, this.getGroup().getSize().x, Math.max(this.titleAreaHeight, toggleHeight), this.gradientColors, this.gradientPercents, this.gradientVertical);
        } else {
            gc.setBackground(this.getGroup().getBackground());
            gc.fillRectangle(0, this.titleHeight - this.titleAreaHeight, this.getGroup().getSize().x, Math.max(this.titleAreaHeight, toggleHeight));
        }
        if ((this.getGroup().getStyle() & 0x10000) != 0) {
            gc.setClipping(null);
            reg.dispose();
        }
        if (image != null) {
            imagePoint.x = (this.getGroup().getImagePosition() & 0x4000) != 0 ? (this.getGroup().getToggleRenderer() != null ? (this.getGroup().getTogglePosition() == 16384 ? this.hMargin + this.getGroup().getToggleRenderer().getSize().x + this.betweenSpacing : this.hMargin) : this.hMargin) : (this.getGroup().getToggleRenderer() != null ? ((this.getGroup().getTogglePosition() & 0x4000) != 0 ? this.getGroup().getSize().x - (this.hMargin + image.getBounds().width) : this.getGroup().getSize().x - (this.hMargin + image.getBounds().width + this.getGroup().getToggleRenderer().getSize().x + this.betweenSpacing)) : this.getGroup().getSize().x - (this.hMargin + image.getBounds().width));
            imagePoint.y = (this.getGroup().getImagePosition() & 0x80) == 0 && image.getImageData().height > this.titleHeight ? (this.titleHeight - image.getImageData().height) / 2 : (this.titleHeight - image.getImageData().height) / 2;
            gc.drawImage(image, imagePoint.x, imagePoint.y);
        }
        Rectangle textBounds = this.getTextBounds();
        String shortened = TextUtils.getShortString(gc, this.getGroup().getText(), textBounds.width);
        if (this.getGroup().getToolItems().length > 0 && this.getGroup().getToolItemRenderer() != null) {
            PGroupToolItem[] items = this.getGroup().getToolItems();
            AbstractToolItemRenderer renderer = this.getGroup().getToolItemRenderer();
            Point size = new Point(0, 0);
            Point minSize = new Point(0, 0);
            int spacing = 3;
            int i = 0;
            while (i < items.length) {
                PGroupToolItem item = items[i];
                Point s0 = renderer.computeSize(gc, item, 1);
                Point s1 = renderer.computeSize(gc, item, 2);
                size.x += s0.x + spacing;
                minSize.x += s1.x + spacing;
                ++i;
            }
            boolean min = false;
            if (shortened.length() != this.getGroup().getText().length()) {
                textBounds.width -= minSize.x;
                min = true;
            } else if (!TextUtils.getShortString(gc, this.getGroup().getText(), textBounds.width - size.x).equals(this.getGroup().getText())) {
                textBounds.width -= minSize.x;
                min = true;
            } else {
                textBounds.width -= size.x;
            }
            shortened = TextUtils.getShortString(gc, this.getGroup().getText(), textBounds.width);
            int x = textBounds.x + textBounds.width;
            this.toolItemArea = min ? new Rectangle(x, this.titleHeight - this.titleAreaHeight + 2, minSize.x, Math.max(this.titleAreaHeight, toggleHeight) - 4) : new Rectangle(x, this.titleHeight - this.titleAreaHeight + 2, size.x, Math.max(this.titleAreaHeight, toggleHeight) - 4);
        }
        gc.setForeground(this.getGroup().getForeground());
        gc.drawText(shortened, textBounds.x, textBounds.y, true);
        if (!this.getGroup().getExpanded()) {
            gc.setBackground(this.getGroup().getParent().getBackground());
        } else {
            Color _borderColor = this.borderColor == null ? this.getGroup().getBackground() : this.borderColor;
            if ((this.getGroup().getStyle() & 0x10000) != 0) {
                gc.setBackground(this.getGroup().getBackground());
                gc.setForeground(_borderColor);
                reg = new Region((Device)this.getGroup().getDisplay());
                reg.add(0, 0, this.getGroup().getSize().x, this.getGroup().getSize().y);
                int yOffset = this.getGroup().getSize().y;
                reg.subtract(0, yOffset - 1, 5, 1);
                reg.subtract(0, yOffset - 2, 3, 1);
                reg.subtract(0, yOffset - 3, 2, 1);
                reg.subtract(0, yOffset - 4, 1, 1);
                reg.subtract(0, yOffset - 5, 1, 1);
                reg.subtract(this.getGroup().getSize().x - 5, yOffset - 1, 5, 1);
                reg.subtract(this.getGroup().getSize().x - 3, yOffset - 2, 3, 1);
                reg.subtract(this.getGroup().getSize().x - 2, yOffset - 3, 2, 1);
                reg.subtract(this.getGroup().getSize().x - 1, yOffset - 4, 1, 1);
                reg.subtract(this.getGroup().getSize().x - 1, yOffset - 5, 1, 1);
                gc.setClipping(reg);
                GraphicUtils.drawRoundRectangle(gc, 0, this.titleHeight, this.getGroup().getSize().x - 1, this.getGroup().getSize().y - this.titleHeight, null, false, true);
                reg.dispose();
                gc.setClipping(null);
            } else {
                gc.setForeground(_borderColor);
                gc.drawRectangle(0, this.titleHeight, this.getGroup().getBounds().width - 1, this.getGroup().getBounds().height - this.titleHeight - 1);
            }
        }
        gc.setBackground(this.getGroup().getBackground());
        gc.setForeground(this.getGroup().getForeground());
    }

    public Rectangle getToolItemArea() {
        return this.toolItemArea;
    }

    public boolean isToggleLocation(int x, int y) {
        if (this.getGroup().getToolItems().length == 0) {
            return y >= this.titleHeight - this.titleAreaHeight && y <= this.titleHeight;
        }
        return super.isToggleLocation(x, y);
    }

    protected Rectangle getTextBounds() {
        Point textPoint = new Point(0, 0);
        int textWidth = 0;
        Image image = this.getGroup().getImage();
        int titleAreaHeight = 0;
        if (image != null && (this.getGroup().getImagePosition() & 0x80) != 0) {
            titleAreaHeight = this.fontHeight + 2 * this.titleTextMargin + 2 * this.vMargin;
            if (this.getGroup().getToggleRenderer() != null) {
                titleAreaHeight = Math.max(titleAreaHeight, this.getGroup().getToggleRenderer().getSize().y + 2 * this.vMargin);
            }
        }
        textPoint.x = this.hMargin;
        if (image != null) {
            if ((this.getGroup().getImagePosition() & 0x4000) != 0) {
                textPoint.x += image.getBounds().width + this.betweenSpacing;
            }
            textPoint.y = (this.getGroup().getImagePosition() & 0x80) == 0 ? (this.titleHeight - this.fontHeight) / 2 : this.titleHeight - titleAreaHeight + (titleAreaHeight - this.fontHeight) / 2;
        } else {
            textPoint.y = (this.titleHeight - this.fontHeight) / 2;
        }
        if (this.getGroup().getToggleRenderer() != null && (this.getGroup().getTogglePosition() & 0x4000) != 0) {
            textPoint.x += this.getGroup().getToggleRenderer().getSize().x + this.betweenSpacing;
        }
        textWidth = this.getGroup().getSize().x - this.hMargin * 2;
        if (image != null) {
            textWidth -= image.getBounds().width + this.betweenSpacing;
        }
        if (this.getGroup().getToggleRenderer() != null) {
            textWidth -= this.getGroup().getToggleRenderer().getSize().x + this.betweenSpacing;
        }
        return new Rectangle(textPoint.x, textPoint.y, textWidth, this.fontHeight);
    }

    public Rectangle getClientArea() {
        Rectangle area = this.getGroup().getBounds();
        area.x = this.margin;
        area.y = this.titleHeight + 1;
        area.width -= 2 * this.margin;
        area.height = (this.getGroup().getStyle() & 0x10000) != 0 ? (area.height -= this.titleHeight + 5 + 1) : (area.height -= this.titleHeight + this.margin + 1);
        return area;
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        Rectangle area = new Rectangle(x, y, width, height);
        area.x -= this.margin;
        area.y -= this.titleHeight;
        area.width += 2 * this.margin;
        area.height += this.titleHeight;
        if (this.getGroup().getExpanded()) {
            area.height = (this.getGroup().getStyle() & 0x10000) != 0 ? (area.height += 5) : (area.height += this.margin);
        }
        return area;
    }

    public void dispose() {
        this.g1.dispose();
        this.g2.dispose();
    }

    public void setBackground(Color[] colors, int[] percents) {
        this.setBackground(colors, percents, false);
    }

    public void setBackground(Color[] colors, int[] percents, boolean vertical) {
        if (colors != null) {
            if (percents == null || percents.length != colors.length - 1) {
                throw new RuntimeException("Percents array must be one item less than the colors array");
            }
            if (this.getGroup().getDisplay().getDepth() < 15) {
                colors = new Color[]{colors[colors.length - 1]};
                percents = new int[]{};
            }
            int i = 0;
            while (i < percents.length) {
                if (percents[i] < 0 || percents[i] > 100) {
                    throw new RuntimeException("Percent array item out of range");
                }
                if (i > 0) {
                    int cfr_ignored_0 = percents[i];
                    int cfr_ignored_1 = percents[i - 1];
                }
                ++i;
            }
        }
        Color background = this.getGroup().getBackground();
        if (this.gradientColors != null && colors != null && this.gradientColors.length == colors.length) {
            boolean same = false;
            int i = 0;
            while (i < this.gradientColors.length) {
                boolean bl = same = this.gradientColors[i] == colors[i] || this.gradientColors[i] == null && colors[i] == background || this.gradientColors[i] == background && colors[i] == null;
                if (!same) break;
                ++i;
            }
            if (same) {
                i = 0;
                while (i < this.gradientPercents.length) {
                    boolean bl = same = this.gradientPercents[i] == percents[i];
                    if (!same) break;
                    ++i;
                }
            }
            if (same && this.gradientVertical == vertical) {
                return;
            }
        }
        if (colors == null) {
            this.gradientColors = null;
            this.gradientPercents = null;
            this.gradientVertical = false;
        } else {
            this.gradientColors = new Color[colors.length];
            int i = 0;
            while (i < colors.length) {
                this.gradientColors[i] = colors[i] != null ? colors[i] : background;
                ++i;
            }
            this.gradientPercents = new int[percents.length];
            i = 0;
            while (i < percents.length) {
                this.gradientPercents[i] = percents[i];
                ++i;
            }
            this.gradientVertical = vertical;
        }
        this.getGroup().redraw();
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public void update() {
        GC gc = new GC((Drawable)this.getGroup());
        this.titleHeight = 0;
        int imageHeight = 0;
        if (this.getGroup().getImage() != null) {
            imageHeight = this.getGroup().getImage().getBounds().height;
        }
        if ((this.getGroup().getImagePosition() & 0x80) == 0) {
            this.titleHeight = Math.max(gc.getFontMetrics().getHeight() + 2 * this.titleTextMargin, imageHeight);
            this.titleHeight += 2 * this.vMargin;
        } else {
            this.titleHeight = Math.max(gc.getFontMetrics().getHeight() + 2 * this.titleTextMargin + 2 * this.vMargin, imageHeight + 1);
        }
        if (this.getGroup().getToggleRenderer() != null) {
            int toggleHeight = this.getGroup().getToggleRenderer().getSize().y;
            this.titleHeight = Math.max(toggleHeight + 2 * this.vMargin, this.titleHeight);
        }
        this.fontHeight = gc.getFontMetrics().getHeight();
        this.titleAreaHeight = this.fontHeight + 2 * this.titleTextMargin + 2 * this.vMargin;
        if (this.getGroup().getToggleRenderer() != null) {
            this.titleAreaHeight = Math.max(this.titleAreaHeight, this.getGroup().getToggleRenderer().getSize().y + 2 * this.vMargin);
        }
        gc.dispose();
    }
}

