/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common.state;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.simantics.browsing.ui.ExplorerState;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.StatePersistor;
import org.simantics.browsing.ui.common.state.GraphExplorerStateBean;
import org.simantics.browsing.ui.common.state.GraphExplorerStateNodeBean;
import org.simantics.databoard.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentifiedStatePersistor
implements StatePersistor {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifiedStatePersistor.class);
    protected final String id;

    public IdentifiedStatePersistor(String id) {
        this.id = id;
    }

    public ExplorerState deserialize(File stateLocation, NodeContext root) {
        return stateLocation == null ? ExplorerState.EMPTY : this.deserialize(this.getMementoPath(stateLocation, root));
    }

    public void serialize(File stateLocation, NodeContext root, ExplorerState state) {
        if (stateLocation == null || root == null) {
            return;
        }
        try {
            GraphExplorerStateBean bean = this.toStateBean(state, root);
            Path memento = this.getMementoPath(stateLocation, root);
            if (bean != null && memento != null) {
                Files.write(memento, bean.serialize(), new OpenOption[0]);
            }
        }
        catch (Throwable t) {
            LOGGER.error("Failed to serialize ExplorerState " + state, t);
        }
    }

    protected ExplorerState deserialize(Path path) {
        if (path == null || !Files.exists(path, new LinkOption[0])) {
            return ExplorerState.EMPTY;
        }
        try {
            GraphExplorerStateBean stateBean = new GraphExplorerStateBean();
            stateBean.deserialize(Files.readAllBytes(path));
            return this.toState(stateBean);
        }
        catch (Throwable t) {
            LOGGER.error("Failed to deserialize ExplorerState from " + path, t);
            return ExplorerState.EMPTY;
        }
    }

    protected NodeContext[] toNodeContexts(GraphExplorerStateNodeBean[] beans) throws Exception {
        return NodeContext.NONE;
    }

    protected List<NodeContext> toNodeContextList(GraphExplorerStateNodeBean[] beans) throws Exception {
        return beans.length == 0 ? Collections.emptyList() : Arrays.asList(this.toNodeContexts(beans));
    }

    protected GraphExplorerStateNodeBean[] toNodeBeans(NodeContext[] contexts) {
        return GraphExplorerStateNodeBean.NONE;
    }

    protected ExplorerState toState(GraphExplorerStateBean stateBean) throws Exception {
        return new ExplorerState(this.toNodeContexts(stateBean.topNodePath), stateBean.topNodePathChildIndexes, this.toNodeContextList(stateBean.expandedNodes), stateBean.columnWidths);
    }

    protected GraphExplorerStateBean toStateBean(ExplorerState state, NodeContext root) {
        GraphExplorerStateBean ib = new GraphExplorerStateBean();
        ib.topNodePath = this.toNodeBeans(state.topNodePath);
        ib.topNodePathChildIndexes = state.topNodePathChildIndex;
        ib.expandedNodes = this.toNodeBeans(state.expandedNodes.toArray(NodeContext.NONE));
        ib.columnWidths = state.columnWidths;
        return ib;
    }

    protected Path getMementoPath(File stateLocation, NodeContext root) {
        return stateLocation.toPath().resolve(String.valueOf(StringUtil.escapeToFileName((String)this.id)) + ".ge");
    }
}

