/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.graph;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.db.impl.graph.BarrierTracing;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.impl.query.CacheEntry;
import org.simantics.db.impl.query.QueryProcessor;

public final class AsyncBarrierImpl
extends AtomicInteger
implements QueryProcessor.AsyncBarrier {
    private static final long serialVersionUID = 4724463372850048672L;
    static final int WAIT_TIME = 600;
    public static final boolean PRINT = false;
    public final AsyncBarrierImpl caller;

    public AsyncBarrierImpl(AsyncBarrierImpl caller, CacheEntry<?> entry) {
        super(0);
        this.caller = caller;
    }

    @Override
    public void inc() {
        this.inc(null, null);
    }

    void inc(Object id, String info) {
        if (this.incrementAndGet() == 1 && this.caller != null) {
            this.caller.inc(null, null);
        }
    }

    @Override
    public void dec() {
        int count = this.decrementAndGet();
        if (count < 1) {
            if (count == 0 && this.caller != null) {
                this.caller.dec();
            }
            if (count < 0) {
                Logger.defaultLogError((String)"Database request processing error. The application code has performed illegal actions (probably called multiple times the execute or exception method of a single result request.", (Throwable)new Exception());
            }
            assert (count >= 0);
        }
    }

    public static String report(AsyncBarrierImpl barrier) {
        CacheEntry<?> e = BarrierTracing.entryMap.get(barrier);
        if (e != null) {
            return e.toString();
        }
        return "Barrier@" + System.identityHashCode(barrier);
    }

    public static void printReverse(AsyncBarrierImpl barrier, int indent) {
        if (barrier.get() == 0) {
            return;
        }
        int i = 0;
        while (i < indent) {
            System.err.print(" ");
            ++i;
        }
        System.err.println("[" + barrier.get() + " requests]: " + AsyncBarrierImpl.report(barrier));
        Collection<AsyncBarrierImpl> children = BarrierTracing.reverseLookup.get(barrier);
        if (children != null) {
            for (AsyncBarrierImpl child : children) {
                AsyncBarrierImpl.printReverse(child, indent + 2);
            }
        }
    }

    public void waitBarrier(Object request, ReadGraphImpl impl) {
        if (this.get() > 0) {
            long waitCount = 0L;
            while (this.get() != 0) {
                boolean executed = impl.performPending();
                if (executed) {
                    waitCount = 0L;
                }
                if (++waitCount > 100L) {
                    Thread.yield();
                }
                if (waitCount > 1000L) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (waitCount <= 600000L) continue;
                System.err.println("AsyncBarrierImpl.waitBarrier(" + request + ") is taking long to execute, so far " + waitCount / 1000L + " s.");
                throw new RuntimeDatabaseException("Request timed out.");
            }
        }
    }

    public void restart() {
        this.assertReady();
    }

    public void assertReady() {
        int current = this.get();
        if (current != 0) {
            throw new AssertionError((Object)("Barrier was not finished (pending=" + current + ")."));
        }
    }

    public void report() {
    }

    @Override
    public String toString() {
        return AsyncBarrierImpl.report(this);
    }
}

