/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.graph;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.simantics.db.Resource;
import org.simantics.db.impl.query.IntSet;
import org.simantics.db.impl.query.QuerySupport;

public class ArraySet
implements Set<Resource> {
    final Resource[] set;

    ArraySet(IntSet intSet, QuerySupport support) {
        if (intSet.data == null) {
            this.set = intSet.sizeOrData != -1 ? new Resource[]{support.getResource(intSet.sizeOrData)} : Resource.NONE;
        } else {
            this.set = new Resource[intSet.sizeOrData];
            int i = 0;
            while (i < intSet.sizeOrData) {
                this.set[i] = support.getResource(intSet.data[i]);
                ++i;
            }
        }
    }

    @Override
    public boolean add(Resource e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Resource> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        int i = 0;
        while (i < this.set.length) {
            if (o.equals(this.set[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.set.length == 0;
    }

    @Override
    public Iterator<Resource> iterator() {
        class ArraySetIterator
        implements Iterator<Resource> {
            int next = 0;

            ArraySetIterator() {
            }

            @Override
            public boolean hasNext() {
                return this.next < ArraySet.this.set.length;
            }

            @Override
            public Resource next() {
                return ArraySet.this.set[this.next++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
        return new ArraySetIterator();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.set.length;
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }
}

