/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.synchronization.base;

import gnu.trove.map.hash.THashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.structural.synchronization.utils.ComponentBase;

public class UpdateComponentUids<T extends ComponentBase<T>> {
    private THashMap<String, String> oldToNewUids;
    private IProgressMonitor monitor;
    private ComponentUpdateProgressMonitor componentMonitor;
    private ReadGraph graph;
    private int componentCount;
    private int counter;

    private UpdateComponentUids(IProgressMonitor monitor, ReadGraph graph, int componentCount) {
        this.monitor = monitor;
        this.componentMonitor = monitor instanceof ComponentUpdateProgressMonitor ? (ComponentUpdateProgressMonitor)monitor : null;
        this.graph = graph;
        this.componentCount = componentCount;
        this.oldToNewUids = new THashMap(componentCount);
    }

    private void update(T component, Variable variable) throws DatabaseException {
        String newUid = variable.getRVI(this.graph).toString();
        this.oldToNewUids.put((Object)((ComponentBase)component).uid, (Object)newUid);
        ((ComponentBase)component).uid = newUid;
        ++this.counter;
        if (this.monitor != null) {
            if (this.componentMonitor != null) {
                this.componentMonitor.componentsDone(this.counter, this.componentCount);
            }
            if (this.monitor.isCanceled()) {
                throw new CancelTransactionException();
            }
        }
        for (Variable childVariable : variable.getChildren(this.graph)) {
            String childName = childVariable.getName(this.graph);
            ComponentBase childComponent = component.getChild(childName);
            if (childComponent == null) continue;
            this.update(childComponent, childVariable);
        }
    }

    public static <T extends ComponentBase<T>> THashMap<String, String> update(ReadGraph graph, T component, Variable variable) throws DatabaseException {
        return UpdateComponentUids.update(null, graph, component, variable);
    }

    public static <T extends ComponentBase<T>> THashMap<String, String> update(IProgressMonitor monitor, ReadGraph graph, T component, Variable variable) throws DatabaseException {
        UpdateComponentUids<T> updateComponentUids = new UpdateComponentUids<T>(monitor, graph, UpdateComponentUids.countComponents(component));
        super.update(component, variable);
        return updateComponentUids.oldToNewUids;
    }

    public static <T extends ComponentBase<T>> int countComponents(T component) {
        return new Counter<T>().count(component);
    }

    public static interface ComponentUpdateProgressMonitor {
        public void componentsDone(int var1, int var2);
    }

    private static class Counter<T extends ComponentBase<T>> {
        int counter;

        private Counter() {
        }

        int count(T component) {
            ++this.counter;
            for (ComponentBase child : component.getChildren()) {
                this.count(child);
            }
            return this.counter;
        }
    }
}

