/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.layer0.request;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.ValueAccessor;
import org.simantics.db.layer0.variable.VariableBuilder;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Pair;

public class PropertyInfo {
    public final Resource predicate;
    public final String name;
    public final boolean isHasProperty;
    public final Set<String> classifications;
    public final VariableBuilder builder;
    public final Resource literalRange;
    public final Datatype requiredDatatype;
    public final String requiredValueType;
    public final String definedUnit;
    public final Binding defaultBinding;
    public final Map<String, Pair<Resource, ChildReference>> subliteralPredicates;
    public final ValueAccessor valueAccessor;
    public final boolean hasEnumerationRange;

    public PropertyInfo(Resource predicate, String name, boolean isHasProperty, Set<String> classifications, VariableBuilder builder, Resource literalRange, Datatype requiredDatatype, String definedUnit, String requiredValueType, Binding defaultBinding, Map<String, Pair<Resource, ChildReference>> subliteralPredicates, ValueAccessor valueAccessor, boolean hasEnumerationRange) {
        this.predicate = predicate;
        this.name = name;
        this.isHasProperty = isHasProperty;
        this.classifications = classifications;
        this.builder = builder;
        this.literalRange = literalRange;
        this.requiredDatatype = requiredDatatype;
        this.definedUnit = definedUnit;
        this.requiredValueType = requiredValueType;
        this.defaultBinding = defaultBinding;
        this.subliteralPredicates = subliteralPredicates;
        this.valueAccessor = valueAccessor;
        this.hasEnumerationRange = hasEnumerationRange;
    }

    public static PropertyInfo make(ReadGraph graph, Resource predicate, String name, boolean isHasProperty, Set<String> classifications, VariableBuilder builder, Resource literalRange, Datatype requiredDatatype, String definedUnit, String requiredValueType, Map<String, Pair<Resource, ChildReference>> subliteralPredicates, ValueAccessor valueAccessor, boolean hasEnumerationRange) throws DatabaseException {
        Collection dts;
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        if (literalRange != null && (dts = graph.getAssertedObjects(literalRange, L0.HasDataType)).size() == 1) {
            Datatype dt = (Datatype)graph.getPossibleValue((Resource)dts.iterator().next(), Bindings.DATATYPE);
            if (requiredDatatype == null) {
                requiredDatatype = dt;
            }
        }
        Binding defaultBinding = requiredDatatype != null ? Bindings.getBinding((Datatype)requiredDatatype) : null;
        return new PropertyInfo(predicate, name, isHasProperty, classifications, builder, literalRange, requiredDatatype, definedUnit, requiredValueType, defaultBinding, subliteralPredicates, valueAccessor, hasEnumerationRange);
    }

    public boolean hasClassification(String classification) {
        return this.classifications.contains(classification);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PropertyInfo [").append(this.name).append(" : ").append(this.requiredDatatype).append(" :: ").append(this.requiredValueType).append(", predicate=").append(this.predicate).append(", isHasProperty=").append(this.isHasProperty).append(", hasEnumerationRange=").append(this.hasEnumerationRange).append(", definedUnit=").append(this.definedUnit != null ? this.definedUnit : "<none>").append(", defaultBinding=").append(this.defaultBinding).append(", valueAccessor=").append(this.valueAccessor).append("]");
        return sb.toString();
    }
}

