/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.reflection.tests;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.reflection.MinimalTypeBindingScheme;
import org.simantics.scl.reflection.ReflectionUtils;
import org.simantics.scl.reflection.TypeBindingScheme;
import org.simantics.scl.runtime.function.Function;

public class TestReflectionUtils {
    @Test
    public void testReflectionUtils() throws Exception {
        MinimalTypeBindingScheme s = MinimalTypeBindingScheme.INSTANCE;
        Class<?> c = this.getClass();
        Assert.assertTrue((boolean)ReflectionUtils.isAssignableFrom((TypeBindingScheme)s, Types.parseType((String)"Integer"), Integer.class));
        Assert.assertTrue((boolean)ReflectionUtils.isAssignableFrom((TypeBindingScheme)s, Types.parseType((String)"Integer"), Integer.TYPE));
        Assert.assertTrue((boolean)ReflectionUtils.isAssignableFrom((TypeBindingScheme)s, Types.parseType((String)"String"), String.class));
        Assert.assertTrue((boolean)ReflectionUtils.isAssignableFrom((TypeBindingScheme)s, Types.parseType((String)"[String]"), List.class));
        Assert.assertTrue((boolean)ReflectionUtils.isAssignableFrom((TypeBindingScheme)s, Types.parseType((String)"[String]"), ArrayList.class));
        Assert.assertTrue((boolean)ReflectionUtils.isAssignableFrom((TypeBindingScheme)s, List.class, Types.parseType((String)"[String]")));
        Assert.assertFalse((boolean)ReflectionUtils.isAssignableFrom((TypeBindingScheme)s, ArrayList.class, Types.parseType((String)"[String]")));
        Assert.assertTrue((boolean)ReflectionUtils.isAssignableFrom((TypeBindingScheme)s, Types.parseType((String)"String -> String"), Function.class));
        Assert.assertTrue((boolean)ReflectionUtils.isCompatible((TypeBindingScheme)s, Types.parseType((String)"String -> Integer"), c.getMethod("method1", String.class)));
        Assert.assertTrue((boolean)ReflectionUtils.isCompatible((TypeBindingScheme)s, Types.parseType((String)"String -> ()"), c.getMethod("method2", String.class)));
        Assert.assertTrue((boolean)ReflectionUtils.isCompatible((TypeBindingScheme)s, Types.parseType((String)"Integer"), c.getMethod("method3", new Class[0])));
        Assert.assertFalse((boolean)ReflectionUtils.isAssignableFrom((TypeBindingScheme)s, Types.parseType((String)"String"), Integer.class));
    }

    public static int method1(String a) {
        return a.length();
    }

    public static void method2(String a) {
        System.out.println(a);
    }

    public static int method3() {
        return 3;
    }
}

