/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.tooltip;

import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.tooltip.FocusableTooltipProvider;

public abstract class EditableTextTooltipProvider2
implements FocusableTooltipProvider {
    private Shell shell;
    private Text text;
    boolean has_focus = false;

    @Override
    public void showTooltip(final IElement element, final int x, final int y) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (EditableTextTooltipProvider2.this.shell != null) {
                    EditableTextTooltipProvider2.this.shell.dispose();
                    EditableTextTooltipProvider2.this.shell = null;
                }
                EditableTextTooltipProvider2.this.shell = new Shell(Display.getCurrent().getActiveShell(), 8);
                EditableTextTooltipProvider2.this.shell.setLayout((Layout)new FillLayout());
                Composite composite = new Composite((Composite)EditableTextTooltipProvider2.this.shell, 2048);
                composite.setLayout((Layout)new FillLayout(512));
                Label label = new Label(composite, 0);
                label.setText("Press 'F9' to focus");
                EditableTextTooltipProvider2.this.text = new Text(composite, 4);
                EditableTextTooltipProvider2.this.text.setText(EditableTextTooltipProvider2.this.getTooltipText(element));
                EditableTextTooltipProvider2.this.text.addKeyListener((KeyListener)new KeyAdapter(){

                    public void keyReleased(KeyEvent e) {
                        if (e.keyCode == 13) {
                            EditableTextTooltipProvider2.this.setText(element, EditableTextTooltipProvider2.this.text.getText());
                            EditableTextTooltipProvider2.this.shell.dispose();
                            EditableTextTooltipProvider2.this.shell = null;
                        }
                    }
                });
                EditableTextTooltipProvider2.this.shell.pack();
                EditableTextTooltipProvider2.this.shell.setVisible(true);
                EditableTextTooltipProvider2.this.shell.setLocation(x, y - 32);
            }
        });
    }

    @Override
    public void hideTooltip(IElement element) {
        if (this.shell == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                EditableTextTooltipProvider2.this.shell.dispose();
                EditableTextTooltipProvider2.this.shell = null;
            }
        });
    }

    @Override
    public void focus() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!EditableTextTooltipProvider2.this.shell.isDisposed()) {
                    EditableTextTooltipProvider2.this.shell.forceFocus();
                }
            }
        });
    }

    @Override
    public boolean hasFocus() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                EditableTextTooltipProvider2.this.has_focus = EditableTextTooltipProvider2.this.shell != null && !EditableTextTooltipProvider2.this.shell.isDisposed() ? EditableTextTooltipProvider2.this.shell.isFocusControl() || EditableTextTooltipProvider2.this.text.isFocusControl() : false;
            }
        });
        return this.has_focus;
    }

    public abstract String getTooltipText(IElement var1);

    public abstract void setText(IElement var1, String var2);
}

