/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.participant;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.scenegraph.g2d.events.Event;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.TimeEvent;
import org.simantics.utils.datastructures.disposable.DisposeState;
import org.simantics.utils.datastructures.hints.HintListenerAdapter;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;
import org.simantics.utils.threads.ThreadUtils;

public class TimeParticipant
extends AbstractCanvasParticipant {
    public static final IHintContext.Key KEY_TIMER_ENABLED = new IHintContext.KeyOf(Boolean.class);
    public static final IHintContext.Key KEY_TIME = new IHintContext.KeyOf(Long.class);
    public static final IHintContext.Key KEY_TIME_PULSE_INTERVAL = new IHintContext.KeyOf(Long.class);
    public static final long DEFAULT_INTERVAL = 100L;
    ScheduledFuture<?> future = null;
    Set<Class<?>> eventRecipients = new HashSet();
    IHintListener hintChangeListener = new HintListenerAdapter(){

        public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
            if (key == KEY_TIME_PULSE_INTERVAL || key == KEY_TIMER_ENABLED) {
                TimeParticipant.this.updateInterval();
            }
        }
    };
    private boolean commandInQueue = false;
    private long prevTime = System.currentTimeMillis();
    private final Runnable onEvent = new Runnable(){

        @Override
        public void run() {
            if (TimeParticipant.this.isRemoved() || !TimeParticipant.this.hasRecipients() || !TimeParticipant.this.isTimerEnabled()) {
                TimeParticipant.this.cancelTimer();
                return;
            }
            if (TimeParticipant.this.commandInQueue) {
                return;
            }
            ICanvasContext ctx = TimeParticipant.this.getContext();
            if (ctx == null || ctx.getDisposeState() != DisposeState.Alive) {
                return;
            }
            long pTime = TimeParticipant.this.prevTime;
            Long time = System.currentTimeMillis();
            long interval = time - pTime;
            TimeParticipant.this.prevTime = time;
            TimeParticipant.this.setHint(KEY_TIME, time);
            TimeEvent e = new TimeEvent((Object)TimeParticipant.this.getContext(), pTime, interval);
            TimeParticipant.this.commandInQueue = true;
            TimeParticipant.this.getContext().getEventQueue().queueFirst((Event)e);
        }
    };
    Runnable onTimer = new Runnable(){

        @Override
        public void run() {
            TimeParticipant.this.asyncExec(TimeParticipant.this.onEvent);
        }
    };

    public void registerForEvents(Class<?> clazz) {
        boolean isEmpty = this.eventRecipients.isEmpty();
        boolean added = this.eventRecipients.add(clazz);
        if (isEmpty && added) {
            this.updateInterval();
        }
    }

    public void unregisterForEvents(Class<?> clazz) {
        this.eventRecipients.remove(clazz);
        if (this.eventRecipients.isEmpty()) {
            this.cancelTimer();
        }
    }

    private boolean hasRecipients() {
        return !this.eventRecipients.isEmpty();
    }

    public boolean isTimerEnabled() {
        return (Boolean)this.getHint(KEY_TIMER_ENABLED);
    }

    public void setTimerEnabled(boolean enabled) {
        this.setHint(KEY_TIMER_ENABLED, enabled);
    }

    public long getInterval() {
        Long interval = (Long)this.getHint(KEY_TIME_PULSE_INTERVAL);
        if (interval == null) {
            return 100L;
        }
        return interval;
    }

    public void setInterval(long interval) {
        this.setHint(KEY_TIME_PULSE_INTERVAL, interval);
    }

    @Override
    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        this.setHint(KEY_TIMER_ENABLED, Boolean.FALSE);
        this.setHint(KEY_TIME_PULSE_INTERVAL, 100L);
        ctx.getHintStack().addKeyHintListener(this.getContext().getThreadAccess(), KEY_TIME_PULSE_INTERVAL, this.hintChangeListener);
        ctx.getHintStack().addKeyHintListener(this.getContext().getThreadAccess(), KEY_TIMER_ENABLED, this.hintChangeListener);
        this.updateInterval();
    }

    @Override
    public void removedFromContext(ICanvasContext ctx) {
        ctx.getHintStack().removeKeyHintListener(this.getContext().getThreadAccess(), KEY_TIMER_ENABLED, this.hintChangeListener);
        ctx.getHintStack().removeKeyHintListener(this.getContext().getThreadAccess(), KEY_TIME_PULSE_INTERVAL, this.hintChangeListener);
        this.cancelTimer();
        this.eventRecipients.clear();
        super.removedFromContext(ctx);
    }

    @EventHandlerReflection.EventHandler(priority=0x7FFFFFFF)
    public boolean handleTimeEvent(TimeEvent e) {
        this.commandInQueue = false;
        return false;
    }

    private void updateInterval() {
        this.cancelTimer();
        if (this.isRemoved()) {
            return;
        }
        boolean timerEnabled = this.isTimerEnabled();
        if (!timerEnabled) {
            return;
        }
        long interval = this.getInterval();
        this.future = ThreadUtils.getNonBlockingWorkExecutor().scheduleAtFixedRate(this.onTimer, 100L, interval, TimeUnit.MILLISECONDS);
    }

    private void cancelTimer() {
        if (this.future != null) {
            this.future.cancel(false);
            this.future = null;
        }
    }
}

