/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.element.handler.impl;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.g2d.element.handler.Text;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.nodes.TextNode;
import org.simantics.utils.datastructures.hints.IHintContext;

public class TextPainter
implements SceneGraph {
    private static final long serialVersionUID = -4156239790629253738L;
    static final Font FONT = Font.decode("Arial 6");
    public static final IHintContext.Key SG_NODE = new SceneGraphNodeKey(Node.class, "SUB_SG_NODE");

    @Override
    public void cleanup(IElement e) {
        Node node = (Node)e.removeHint(SG_NODE);
        if (node != null) {
            node.remove();
        }
    }

    @Override
    public void init(IElement e, G2DParentNode parent) {
        TextNode node = (TextNode)e.getHint(SG_NODE);
        if (node == null) {
            node = (TextNode)parent.addNode(TextNode.class);
            e.setHint(SG_NODE, node);
        }
        Color bc = ElementUtils.getTextColor(e, Color.BLACK);
        InternalSize b = e.getElementClass().getSingleItem(InternalSize.class);
        Rectangle2D r = b.getBounds(e, null);
        if (r == null) {
            return;
        }
        Text t = e.getElementClass().getAtMostOneItemOfClass(Text.class);
        if (t == null) {
            return;
        }
        String text = t.getText(e);
        if (text == null) {
            return;
        }
        AffineTransform at = ElementUtils.getTransform(e);
        node.setFont(FONT);
        node.setColor(bc);
        node.setBounds(r);
        node.setText(text);
        node.setTransform(at);
    }
}

