/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.g2d.diagram.handler.impl;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.PickContext;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementLayers;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.Outline;
import org.simantics.g2d.element.handler.Pick;
import org.simantics.g2d.element.handler.Pick2;
import org.simantics.g2d.element.handler.Transform;
import org.simantics.g2d.layers.ILayers;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.nodes.spatial.RTreeNode;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PickContextImpl
implements PickContext {
    public static final PickContextImpl INSTANCE = new PickContextImpl();
    private static final Logger LOGGER = LoggerFactory.getLogger(PickContextImpl.class);
    private static final boolean PERF = false;
    private static final ThreadLocal<Rectangle2D> perThreadElementBounds = ThreadLocal.withInitial(() -> new Rectangle2D.Double());
    private boolean useRTree;

    public PickContextImpl() {
        this(false);
    }

    public PickContextImpl(boolean useRTree) {
        this.useRTree = useRTree;
    }

    @Override
    public void pick(IDiagram diagram, PickRequest request, Collection<IElement> finalResult) {
        assert (diagram != null);
        assert (request != null);
        assert (finalResult != null);
        long startTime = 0L;
        List<IElement> result = this.pickElements(diagram, request);
        if (!result.isEmpty()) {
            if (request.pickSorter != null) {
                ArrayList<IElement> elems = new ArrayList<IElement>(result);
                request.pickSorter.sort(elems);
                finalResult.addAll(elems);
            } else {
                finalResult.addAll(result);
            }
        }
    }

    private static Rectangle2D toBoundingRectangle(Shape shape) {
        if (shape instanceof Rectangle2D) {
            return (Rectangle2D)shape;
        }
        return shape.getBounds2D();
    }

    private List<IElement> pickElements(IDiagram diagram, PickRequest request) {
        INode spatialRoot;
        ILayers layers = (ILayers)diagram.getHint(DiagramHints.KEY_LAYERS);
        INode iNode = spatialRoot = this.useRTree && request.pickContext != null ? request.pickContext.getSceneGraph().lookupNode("spatialRoot") : null;
        if (spatialRoot instanceof RTreeNode) {
            RTreeNode rtree = (RTreeNode)spatialRoot;
            Map nodeToElement = (Map)diagram.getHint(DiagramHints.NODE_TO_ELEMENT_MAP);
            if (nodeToElement != null) {
                return ((Stream)rtree.intersectingNodes(PickContextImpl.toBoundingRectangle(request.pickArea), new ArrayList()).stream().parallel()).map(nodeToElement::get).filter(Objects::nonNull).filter(new PickFilter(request, layers)).collect(Collectors.toList());
            }
            HashSet nodes = new HashSet(rtree.intersectingNodes(PickContextImpl.toBoundingRectangle(request.pickArea), new ArrayList()));
            return ((Stream)diagram.getSnapshot().stream().parallel()).filter(e -> {
                INode node = (INode)e.getHint(ElementHints.KEY_SG_NODE);
                return nodes.contains(node);
            }).filter(new PickFilter(request, layers)).collect(Collectors.toList());
        }
        ArrayList<IElement> result = new ArrayList<IElement>();
        boolean checkLayers = layers != null && !layers.getIgnoreFocusSettings();
        diagram.getSnapshot().stream().forEachOrdered(e -> {
            ElementLayers el;
            if (ElementUtils.isHidden(e)) {
                return;
            }
            ElementClass ec = e.getElementClass();
            if (checkLayers && (el = ec.getAtMostOneItemOfClass(ElementLayers.class)) != null && !el.isFocusable((IElement)e, layers)) {
                return;
            }
            if (pickRequest.pickFilter != null && !pickRequest.pickFilter.accept((IElement)e)) {
                return;
            }
            InternalSize b = ec.getAtMostOneItemOfClass(InternalSize.class);
            if (b == null) {
                return;
            }
            AffineTransform canvasToElement = PickContextImpl.getTransform(e);
            if (canvasToElement == null) {
                return;
            }
            Rectangle2D elementBoundsOnCanvas = PickContextImpl.getElementBounds(e, b, canvasToElement);
            if (elementBoundsOnCanvas == null) {
                return;
            }
            List<Pick> pickHandlers = ec.getItemsByClass(Pick.class);
            if (!pickHandlers.isEmpty()) {
                if (!org.simantics.g2d.utils.GeometryUtils.intersects(pickRequest.pickArea, elementBoundsOnCanvas)) {
                    return;
                }
                for (Pick p : pickHandlers) {
                    if (p instanceof Pick2) {
                        Pick2 p2 = (Pick2)p;
                        if (p2.pick((IElement)e, pickRequest.pickArea, pickRequest.pickPolicy, (Collection<IElement>)result) <= 0) continue;
                        return;
                    }
                    if (!p.pickTest((IElement)e, pickRequest.pickArea, pickRequest.pickPolicy)) continue;
                    result.add((IElement)e);
                    return;
                }
                return;
            }
            List<Outline> outlineHandlers = ec.getItemsByClass(Outline.class);
            if (!outlineHandlers.isEmpty()) {
                if (PickContextImpl.pickByOutline(e, request, elementBoundsOnCanvas, canvasToElement, outlineHandlers)) {
                    result.add((IElement)e);
                }
                return;
            }
            if (PickContextImpl.pickByBounds(e, request, elementBoundsOnCanvas)) {
                result.add((IElement)e);
            }
        });
        return result;
    }

    private static AffineTransform getTransform(IElement e) {
        Transform t = e.getElementClass().getSingleItem(Transform.class);
        AffineTransform canvasToElement = t.getTransform(e);
        if (canvasToElement == null) {
            return null;
        }
        double det = canvasToElement.getDeterminant();
        if (det == 0.0) {
            canvasToElement = AffineTransform.getTranslateInstance(canvasToElement.getTranslateX(), canvasToElement.getTranslateY());
        }
        return canvasToElement;
    }

    private static Rectangle2D getElementBounds(IElement e, InternalSize b, AffineTransform transform) {
        Rectangle2D elementBounds = perThreadElementBounds.get();
        elementBounds.setFrame(Double.NaN, Double.NaN, Double.NaN, Double.NaN);
        b.getBounds(e, elementBounds);
        if (Double.isNaN(elementBounds.getWidth()) || Double.isNaN(elementBounds.getHeight())) {
            return null;
        }
        Rectangle2D transformedBounds = transform != null ? PickContextImpl.toBoundingRectangle(org.simantics.g2d.utils.GeometryUtils.transformShape(elementBounds, transform)) : elementBounds;
        return GeometryUtils.expandRectangle((Rectangle2D)transformedBounds, (double)0.001);
    }

    private static boolean pickByOutline(IElement e, PickRequest request, Rectangle2D elementBoundsOnCanvas, AffineTransform canvasToElement, List<Outline> outlineHandlers) {
        AffineTransform elementToCanvas;
        if (!org.simantics.g2d.utils.GeometryUtils.intersects(request.pickArea, elementBoundsOnCanvas)) {
            return false;
        }
        try {
            elementToCanvas = canvasToElement.createInverse();
        }
        catch (NoninvertibleTransformException ex) {
            throw new RuntimeException(ex);
        }
        Shape pickShapeInElementCoords = org.simantics.g2d.utils.GeometryUtils.transformShape(request.pickArea, elementToCanvas);
        if (request.pickPolicy == PickRequest.PickPolicy.PICK_INTERSECTING_OBJECTS) {
            for (Outline es : outlineHandlers) {
                Shape elementShape = es.getElementShape(e);
                if (elementShape == null) {
                    return false;
                }
                if (!org.simantics.g2d.utils.GeometryUtils.intersects(pickShapeInElementCoords, elementShape)) continue;
                return true;
            }
            return false;
        }
        if (request.pickPolicy == PickRequest.PickPolicy.PICK_CONTAINED_OBJECTS) {
            for (Outline es : outlineHandlers) {
                Shape elementShape = es.getElementShape(e);
                if (org.simantics.g2d.utils.GeometryUtils.contains(pickShapeInElementCoords, elementShape)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static boolean pickByBounds(IElement e, PickRequest request, Rectangle2D elementBoundsOnCanvas) {
        return request.pickPolicy == PickRequest.PickPolicy.PICK_INTERSECTING_OBJECTS ? org.simantics.g2d.utils.GeometryUtils.intersects(request.pickArea, elementBoundsOnCanvas) : request.pickPolicy == PickRequest.PickPolicy.PICK_CONTAINED_OBJECTS && org.simantics.g2d.utils.GeometryUtils.contains(request.pickArea, (Shape)elementBoundsOnCanvas);
    }

    private static class PickFilter
    implements Predicate<IElement> {
        private final PickRequest request;
        private final ILayers layers;
        private final boolean checkLayers;

        public PickFilter(PickRequest request, ILayers layers) {
            this.request = request;
            this.layers = layers;
            this.checkLayers = layers != null && !layers.getIgnoreFocusSettings();
        }

        @Override
        public boolean test(IElement e) {
            ElementLayers el;
            if (ElementUtils.isHidden(e)) {
                return false;
            }
            ElementClass ec = e.getElementClass();
            if (this.checkLayers && (el = ec.getAtMostOneItemOfClass(ElementLayers.class)) != null && !el.isFocusable(e, this.layers)) {
                return false;
            }
            if (this.request.pickFilter != null && !this.request.pickFilter.accept(e)) {
                return false;
            }
            InternalSize b = ec.getAtMostOneItemOfClass(InternalSize.class);
            if (b == null) {
                return false;
            }
            AffineTransform canvasToElement = PickContextImpl.getTransform(e);
            if (canvasToElement == null) {
                return false;
            }
            Rectangle2D elementBoundsOnCanvas = PickContextImpl.getElementBounds(e, b, canvasToElement);
            if (elementBoundsOnCanvas == null) {
                return false;
            }
            List<Pick> pickHandlers = ec.getItemsByClass(Pick.class);
            if (!pickHandlers.isEmpty()) {
                if (!org.simantics.g2d.utils.GeometryUtils.intersects(this.request.pickArea, elementBoundsOnCanvas)) {
                    return false;
                }
                for (Pick p : pickHandlers) {
                    if (!p.pickTest(e, this.request.pickArea, this.request.pickPolicy)) continue;
                    return true;
                }
                return false;
            }
            List<Outline> outlineHandlers = ec.getItemsByClass(Outline.class);
            if (!outlineHandlers.isEmpty()) {
                return PickContextImpl.pickByOutline(e, this.request, elementBoundsOnCanvas, canvasToElement, outlineHandlers);
            }
            return PickContextImpl.pickByBounds(e, this.request, elementBoundsOnCanvas);
        }
    }
}

