/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.handler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.diagram.content.ConnectionUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.scl.commands.Command;
import org.simantics.scl.commands.Commands;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.contribution.DynamicMenuContribution;
import org.simantics.utils.ui.AdaptionUtils;
import org.simantics.utils.ui.ExceptionUtils;

public class ConnectionRoutingMenuContribution
extends DynamicMenuContribution {
    private static final IContributionItem[] NONE = new IContributionItem[0];

    protected IContributionItem[] getContributionItems(ReadGraph graph, Object[] selection) throws DatabaseException {
        ArrayList<IContributionItem> result = new ArrayList<IContributionItem>(4);
        result.addAll(ConnectionRoutingMenuContribution.getConnectionRoutingItems(graph, selection));
        result.addAll(ConnectionRoutingMenuContribution.getAttachedConnectionRoutingItems(graph, selection));
        return result.toArray(NONE);
    }

    public static Collection<IContributionItem> getConnectionRoutingItems(ReadGraph graph, Object[] selection) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        Collection routings = graph.getObjects(dr.Routing, l0.SuperrelationOf);
        if (routings.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Resource> connections = new ArrayList<Resource>();
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object s = objectArray[n2];
            Resource connection = (Resource)AdaptionUtils.adaptToSingle((Object)s, Resource.class);
            if (connection == null) {
                return Collections.emptyList();
            }
            if (!graph.isInstanceOf(connection, dr.Connection)) {
                return Collections.emptyList();
            }
            if (graph.isInstanceOf(connection, dr.RouteGraphConnection)) {
                return Collections.emptyList();
            }
            connections.add(connection);
            ++n2;
        }
        if (connections.isEmpty()) {
            return Collections.emptyList();
        }
        Resource currentRoute = null;
        for (Resource connection : connections) {
            Statement currentRouting = graph.getPossibleStatement(connection, dr.Routing);
            if (currentRouting == null) continue;
            Resource route = currentRouting.getPredicate();
            if (currentRoute == null) {
                currentRoute = route;
                continue;
            }
            if (currentRoute.equals(route)) continue;
            currentRoute = null;
            break;
        }
        final ArrayList<SetRoutingAction> actions = new ArrayList<SetRoutingAction>();
        for (Resource routing : routings) {
            String text = (String)graph.adapt(routing, String.class);
            SetRoutingAction action = new SetRoutingAction(graph.getSession(), connections, routing, text);
            if (routing.equals(currentRoute)) {
                action.setChecked(true);
            }
            actions.add(action);
        }
        ConnectionRoutingMenuContribution.sort(actions);
        return Collections.singleton(new ContributionItem(){

            public void fill(Menu menu, int index) {
                MenuItem openWith = new MenuItem(menu, 64, index);
                openWith.setText("Connection Routing");
                Menu subMenu = new Menu(menu);
                openWith.setMenu(subMenu);
                for (SetRoutingAction a : actions) {
                    MenuItem item = new MenuItem(subMenu, 32);
                    item.setText(a.getText());
                    item.addSelectionListener((SelectionListener)a);
                    item.setSelection(a.isChecked());
                }
            }
        });
    }

    public static Collection<IContributionItem> getAttachedConnectionRoutingItems(ReadGraph graph, Object[] selection) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
        StructuralResource2 sr = StructuralResource2.getInstance((ReadGraph)graph);
        ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
        Resource ReferenceProvider = graph.getPossibleResource("http://www.apros.fi/Apros-6.1/ReferenceProvider");
        Resource connectionType = graph.getPossibleResource("http://www.simantics.org/Kcleco-5.0/FlowConnection");
        Collection routings = graph.getObjects(dr.Routing, l0.SuperrelationOf);
        if (routings.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Resource> connections = new ArrayList<Resource>();
        ArrayList<Resource> connectors = new ArrayList<Resource>();
        boolean directRoutings = false;
        boolean straightRoutings = false;
        ArrayList<Resource> elements = new ArrayList<Resource>();
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object s = objectArray[n2];
            Resource element = (Resource)AdaptionUtils.adaptToSingle((Object)s, Resource.class);
            if (element == null) {
                return Collections.emptyList();
            }
            if (!graph.isInstanceOf(element, dr.Element) || graph.isInstanceOf(element, dr.Connection)) {
                return Collections.emptyList();
            }
            elements.add(element);
            for (Statement stat : graph.getStatements(element, sr.IsConnectedTo)) {
                Resource connector;
                Resource connection;
                Resource diagramRelation = stat.getPredicate();
                Resource connectionRelation = graph.getPossibleObject(diagramRelation, MOD.DiagramConnectionRelationToConnectionRelation);
                if (connectionRelation == null || ReferenceProvider != null && !graph.isInstanceOf(connectionRelation, ReferenceProvider) || (connection = ConnectionUtil.tryGetConnection(graph, connector = stat.getObject())) == null) continue;
                if (graph.isInstanceOf(connection, dr.RouteGraphConnection)) {
                    if (connectionType != null && graph.isInstanceOf(connection, connectionType)) continue;
                    connectors.add(connector);
                    boolean direct = Boolean.TRUE.equals(graph.getPossibleRelatedValue2(connector, dr.Connector_straight, (Binding)Bindings.BOOLEAN));
                    directRoutings |= direct;
                    straightRoutings |= !direct;
                    continue;
                }
                connections.add(connection);
            }
            ++n2;
        }
        if (connectors.isEmpty() && connections.isEmpty()) {
            return Collections.emptyList();
        }
        Resource currentRoute = null;
        for (Resource connection : connections) {
            Statement currentRouting = graph.getPossibleStatement(connection, dr.Routing);
            if (currentRouting == null) continue;
            Resource route = currentRouting.getPredicate();
            if (currentRoute == null) {
                currentRoute = route;
                continue;
            }
            if (currentRoute.equals(route)) continue;
            currentRoute = null;
            break;
        }
        final ArrayList<SelectionListenerAction> actions = new ArrayList<SelectionListenerAction>();
        if (!connections.isEmpty()) {
            for (Resource routing : routings) {
                String text = (String)graph.adapt(routing, String.class);
                SetRoutingAction action = new SetRoutingAction(graph.getSession(), connections, routing, text);
                if (routing.equals(currentRoute)) {
                    action.setChecked(true);
                }
                actions.add(action);
            }
        }
        if (!connectors.isEmpty()) {
            SetAttachedRouteGraphRoutingAction direct = new SetAttachedRouteGraphRoutingAction(graph.getSession(), elements, true, "Direct");
            SetAttachedRouteGraphRoutingAction straight = new SetAttachedRouteGraphRoutingAction(graph.getSession(), elements, false, "Straight-angled");
            direct.setChecked(directRoutings);
            straight.setChecked(straightRoutings);
            actions.add(direct);
            actions.add(straight);
        }
        ConnectionRoutingMenuContribution.sort(actions);
        return Collections.singleton(new ContributionItem(){

            public void fill(Menu menu, int index) {
                MenuItem openWith = new MenuItem(menu, 64, index);
                openWith.setText("Attached Connection Routing");
                Menu subMenu = new Menu(menu);
                openWith.setMenu(subMenu);
                for (SelectionListenerAction a : actions) {
                    MenuItem item = new MenuItem(subMenu, 32);
                    item.setText(a.getText());
                    item.addSelectionListener((SelectionListener)a);
                    item.setSelection(a.isChecked());
                }
            }
        });
    }

    private static void sort(List<? extends IAction> actions) {
        Collections.sort(actions, new Comparator<IAction>(){

            @Override
            public int compare(IAction o1, IAction o2) {
                return o1.getText().compareToIgnoreCase(o2.getText());
            }
        });
    }

    static abstract class SelectionListenerAction
    extends Action
    implements SelectionListener {
        public SelectionListenerAction(String text) {
            super(text);
        }
    }

    static class SetAttachedRouteGraphRoutingAction
    extends SelectionListenerAction {
        Session session;
        Collection<Resource> elements;
        boolean straight;

        public SetAttachedRouteGraphRoutingAction(Session session, Collection<Resource> elements, boolean straight, String text) {
            super(text);
            this.session = session;
            this.elements = elements;
            this.straight = straight;
        }

        public void run() {
            this.session.asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Command command = Commands.get((ReadGraph)graph, (String)"Simantics/Diagram/setStraightConnectionLines");
                    for (Resource element : elements) {
                        command.execute((RequestProcessor)graph, (Resource)graph.syncRequest((Read)new IndexRoot(element)), new Object[]{element, straight});
                    }
                    CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                    graph.addMetadata((Metadata)cm.add("Set routing for an element."));
                }
            }, parameter -> {
                if (parameter != null) {
                    ExceptionUtils.logError((Throwable)parameter);
                }
            });
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            this.run();
        }
    }

    static class SetRoutingAction
    extends SelectionListenerAction {
        Session session;
        Collection<Resource> connections;
        Resource routingTag;

        public SetRoutingAction(Session session, Collection<Resource> connections, Resource routingTag, String text) {
            super(text);
            this.session = session;
            this.connections = connections;
            this.routingTag = routingTag;
        }

        public void run() {
            this.session.asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
                    for (Resource connection : connections) {
                        graph.deny(connection, dr.Routing);
                        graph.claim(connection, routingTag, connection);
                    }
                }
            }, parameter -> {
                if (parameter != null) {
                    ExceptionUtils.logError((Throwable)parameter);
                }
            });
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            this.run();
        }
    }
}

