/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.flag;

import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.primitiverequest.OrderedSet;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.AsyncMultiRead;
import org.simantics.diagram.flag.FlagLabelingScheme;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;

public class PermutativeFlagLabelingScheme
implements FlagLabelingScheme {
    protected String initialValue;
    protected char min;
    protected char max;

    public PermutativeFlagLabelingScheme(String initialValue, char min, char max) {
        this.initialValue = initialValue;
        this.min = min;
        this.max = max;
    }

    public PermutativeFlagLabelingScheme(String initialValue, String min, String max) {
        this.initialValue = initialValue;
        this.min = min.charAt(0);
        this.max = max.charAt(0);
    }

    protected Set<String> getUsedLabels(ReadGraph graph, Resource diagram) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        TreeSet<String> used = new TreeSet<String>(NameUtils.STRING_CHARBUFFER_COMPARATOR);
        for (Resource element : graph.syncRequest((AsyncMultiRead)new OrderedSet(diagram))) {
            String label;
            if (!graph.isInstanceOf(element, DIA.Flag) || (label = (String)graph.getPossibleRelatedValue(element, L0.HasLabel, (Binding)Bindings.STRING)) == null || label.isEmpty()) continue;
            used.add(label);
        }
        return used;
    }

    @Override
    public String generateLabel(ReadGraph graph, Resource diagram) throws DatabaseException {
        CharBuffer cb = CharBuffer.allocate(10);
        Set<String> used = this.getUsedLabels(graph, diagram);
        this.initialValue(cb);
        cb.limit(cb.position());
        while (used.contains(cb)) {
            this.permutate(cb);
            cb.position(cb.limit());
        }
        cb.rewind();
        return cb.toString();
    }

    protected void initialValue(CharBuffer cb) {
        cb.append(this.initialValue);
    }

    protected void permutate(CharBuffer cb) {
        this.permutate(cb, this.min, this.max);
    }

    protected void permutate(CharBuffer str, char min, char max) {
        int s = str.limit();
        char[] chars = str.array();
        int i = s - 1;
        while (i >= 0) {
            if (chars[i] < max) {
                int n = i;
                chars[n] = (char)(chars[n] + '\u0001');
                int j = i + 1;
                while (j < s) {
                    chars[j] = min;
                    ++j;
                }
                return;
            }
            --i;
        }
        str.limit(s + 1);
        Arrays.fill(chars, 0, s + 1, min);
    }
}

