/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.diagram.adapter;

import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.ServiceLocator;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.diagram.connection.ConnectionVisuals;
import org.simantics.diagram.connection.RouteGraph;
import org.simantics.diagram.connection.RouteGraphConnectionClass;
import org.simantics.diagram.connection.RouteLine;
import org.simantics.diagram.connection.RouteNode;
import org.simantics.diagram.connection.RouteTerminal;
import org.simantics.diagram.connection.RouteTerminalPosition;
import org.simantics.diagram.connection.rendering.BasicConnectionStyle;
import org.simantics.diagram.connection.rendering.ConnectionStyle;
import org.simantics.diagram.connection.rendering.ExampleConnectionStyle;
import org.simantics.diagram.connection.rendering.StyledRouteGraphRenderer;
import org.simantics.diagram.connection.rendering.arrows.ArrowLineEndStyle;
import org.simantics.diagram.connection.rendering.arrows.ILineEndStyle;
import org.simantics.diagram.connection.rendering.arrows.PlainLineEndStyle;
import org.simantics.diagram.content.EdgeResource;
import org.simantics.diagram.content.ResourceTerminal;
import org.simantics.diagram.content.TerminalMap;
import org.simantics.diagram.query.DiagramRequests;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.stubs.G2DResource;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.RouteGraphConnection;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.DataElementMap;
import org.simantics.g2d.diagram.handler.Topology;
import org.simantics.g2d.diagram.impl.ElementDiagram;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.EdgeVisuals;
import org.simantics.g2d.element.handler.TerminalLayout;
import org.simantics.g2d.elementclass.FlagClass;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.g2d.nodes.connection.RouteGraphChangeEvent;
import org.simantics.scenegraph.utils.GeometryUtils;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.modelingRules.CPTerminal;
import org.simantics.structural2.modelingRules.IAttachmentRelationMap;
import org.simantics.structural2.modelingRules.IModelingRules;
import org.simantics.utils.threads.CurrentThread;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteGraphUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RouteGraph.class);
    public static boolean DEBUG = false;
    public static final ILineEndStyle HEAD = new ArrowLineEndStyle("fill 2 1 0");
    public static final ILineEndStyle TAIL = PlainLineEndStyle.INSTANCE;
    private static final ConnectionStyle DEFAULT_CONNECTION_STYLE = new BasicConnectionStyle(Color.BLACK, Color.BLACK, 3.0, (Stroke)ExampleConnectionStyle.SOLID, (Stroke)ExampleConnectionStyle.SOLID, 8.0);
    private static final double DEG_45 = 0.7853981633974483;
    private static final double DEG_135 = 2.356194490192345;

    public static RouteGraph load(ReadGraph graph, Resource diagramRuntime, Resource connection) throws DatabaseException {
        CanvasContext canvas = new CanvasContext(CurrentThread.getThreadAccess());
        ElementDiagram diagram = new ElementDiagram((ICanvasContext)canvas);
        return RouteGraphUtils.load(graph, diagramRuntime, connection, (ICanvasContext)canvas, (IDiagram)diagram);
    }

    public static RouteGraph load(ReadGraph graph, Resource diagramRuntime, Resource connection, ICanvasContext canvas, IDiagram diagram) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Resource diagramResource = graph.getPossibleObject(connection, L0.PartOf);
        IModelingRules modelingRules = (IModelingRules)graph.syncRequest(DiagramRequests.getModelingRules(diagramResource, null), (Listener)TransientCacheListener.instance());
        return RouteGraphUtils.load(graph, diagramRuntime, connection, canvas, diagram, null, modelingRules, null);
    }

    public static RouteGraph load(ReadGraph graph, Resource diagramRuntime, Resource connection, ICanvasContext canvas, IDiagram diagram, IElement element, IModelingRules modelingRules, Set<BackendConnection> backendConnections) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
        RouteGraph rg = new RouteGraph();
        THashSet links = new THashSet();
        THashMap nodeByData = new THashMap();
        for (Resource interiorNode : graph.getObjects(connection, DIA.HasInteriorRouteNode)) {
            if (graph.isInstanceOf(interiorNode, DIA.RouteLine)) {
                Collection areConnected = graph.getObjects(interiorNode, DIA.AreConnected);
                if (areConnected.size() < 2) {
                    LOGGER.warn("Stray RouteLine found: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)interiorNode));
                    continue;
                }
                Boolean isHorizontal = (Boolean)graph.getRelatedValue(interiorNode, DIA.IsHorizontal, (Binding)Bindings.BOOLEAN);
                Double position = (Double)graph.getRelatedValue(interiorNode, DIA.HasPosition, (Binding)Bindings.DOUBLE);
                RouteLine line = rg.addLine(isHorizontal.booleanValue(), position.doubleValue());
                line.setData(RouteGraphConnection.serialize((ServiceLocator)graph, interiorNode));
                nodeByData.put(interiorNode, line);
                for (Resource connectedTo : areConnected) {
                    links.add(new EdgeResource(interiorNode, connectedTo));
                }
                continue;
            }
            graph.isInstanceOf(interiorNode, DIA.RoutePoint);
        }
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        THashMap connectorToModeledAttachment = null;
        Collection toConnectorStatements = graph.getStatements(connection, DIA.HasConnector);
        int terminalCount = 0;
        if (modelingRules != null) {
            for (Statement toConnector : toConnectorStatements) {
                Resource connector = toConnector.getObject();
                Statement terminalStm = RouteGraphUtils.findTerminalStatement(graph, connection, connector, STR);
                if (terminalStm == null) continue;
                Resource terminalElement = terminalStm.getObject();
                Resource connectionRelation = graph.getPossibleInverse(terminalStm.getPredicate());
                if (connectionRelation == null) continue;
                ++terminalCount;
                IAttachmentRelationMap map = modelingRules.getAttachmentRelations(graph, connection);
                Resource attachment = map.get(graph, new CPTerminal(terminalElement, connectionRelation));
                if (attachment != null) {
                    if (connectorToModeledAttachment == null) {
                        connectorToModeledAttachment = new THashMap(toConnectorStatements.size());
                    }
                    connectorToModeledAttachment.put(connector, attachment);
                    if (!DEBUG) continue;
                    LOGGER.debug("modeling rules decided attachment: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)attachment, (boolean)true) + " for (" + NameUtils.toString((ReadGraph)graph, (Statement)toConnector, (boolean)true) + ") & (" + NameUtils.toString((ReadGraph)graph, (Statement)terminalStm, (boolean)true) + ")");
                    continue;
                }
                if (!graph.isInstanceOf(terminalElement, DIA.Flag) || (attachment = RouteGraphUtils.resolveFlagAttachment(graph, connection, terminalElement, modelingRules, DIA)) == null) continue;
                if (connectorToModeledAttachment == null) {
                    connectorToModeledAttachment = new THashMap(toConnectorStatements.size());
                }
                connectorToModeledAttachment.put(connector, attachment);
                if (!DEBUG) continue;
                LOGGER.debug("flag type decided attachment: " + NameUtils.getSafeName((ReadGraph)graph, (Resource)attachment, (boolean)true) + " for (" + NameUtils.toString((ReadGraph)graph, (Statement)toConnector, (boolean)true) + ") & (" + NameUtils.toString((ReadGraph)graph, (Statement)terminalStm, (boolean)true) + ")");
            }
        }
        if (connectorToModeledAttachment == null) {
            connectorToModeledAttachment = Collections.emptyMap();
        }
        Resource forcedAttachmentRelation = null;
        if (terminalCount == 2 && connectorToModeledAttachment.size() == 1) {
            forcedAttachmentRelation = RouteGraphUtils.getInverseAttachment(graph, (Resource)connectorToModeledAttachment.values().iterator().next(), DIA);
            if (DEBUG) {
                LOGGER.debug("set forced attachment: " + NameUtils.getSafeLabel((ReadGraph)graph, (Resource)forcedAttachmentRelation));
            }
        }
        Resource connectionType = graph.getPossibleObject(connection, STR.HasConnectionType);
        DataElementMap diagramDataElementMap = (DataElementMap)diagram.getDiagramClass().getSingleItem(DataElementMap.class);
        for (Statement toConnector : toConnectorStatements) {
            Integer allowedDirections;
            Resource connectionRelation;
            Resource terminalElement;
            Resource terminalElementType;
            Statement terminalStm;
            Resource connector = toConnector.getObject();
            Resource attachmentRelation = toConnector.getPredicate();
            if (DEBUG) {
                LOGGER.debug("original attachment relation: " + NameUtils.getSafeLabel((ReadGraph)graph, (Resource)attachmentRelation));
            }
            if ((terminalStm = RouteGraphUtils.findTerminalStatement(graph, connection, connector, STR)) == null || (terminalElementType = graph.getPossibleType(terminalElement = terminalStm.getObject(), DIA.Element)) == null || (connectionRelation = graph.getPossibleInverse(terminalStm.getPredicate())) == null) continue;
            TerminalMap terminals = (TerminalMap)graph.syncRequest(DiagramRequests.elementTypeTerminals(terminalElementType), (Listener)TransientCacheListener.instance());
            Resource terminal = terminals.getTerminal(connectionRelation);
            if (terminal == null) {
                System.err.println("RouteGraphUtils: Could not find terminal for connection point " + NameUtils.getSafeName((ReadGraph)graph, (Resource)connectionRelation, (boolean)true) + " in element " + NameUtils.getSafeName((ReadGraph)graph, (Resource)terminalElement, (boolean)true));
                continue;
            }
            double[] position = (double[])graph.getRelatedValue(connector, DIA.HasRelativeLocation, (Binding)Bindings.DOUBLE_ARRAY);
            if (position.length != 2) {
                position = new double[]{0.0, 0.0};
            }
            AffineTransform terminalTr = DiagramGraphUtil.getDynamicWorldTransform(graph, diagramRuntime, terminalElement);
            AffineTransform terminalElementTransform = new AffineTransform(terminalTr);
            if (DEBUG) {
                LOGGER.debug("terminalStm: " + NameUtils.toString((ReadGraph)graph, (Statement)terminalStm));
                LOGGER.debug("terminal: " + NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)terminalStm.getPredicate()));
                LOGGER.debug("terminalElement: " + NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)terminalElement) + " : " + NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)terminalElementType));
                LOGGER.debug("terminalElementTr: " + terminalTr);
            }
            double x = terminalTr.getTranslateX();
            double y = terminalTr.getTranslateY();
            double minx = x - 1.0;
            double miny = y - 1.0;
            double maxx = x + 1.0;
            double maxy = y + 1.0;
            int direction = 0;
            Resource att = (Resource)connectorToModeledAttachment.get(connector);
            if (att != null) {
                attachmentRelation = att;
                if (DEBUG) {
                    LOGGER.debug("modeling rules attachment: " + NameUtils.getSafeLabel((ReadGraph)graph, (Resource)attachmentRelation));
                }
            } else if (forcedAttachmentRelation != null) {
                attachmentRelation = forcedAttachmentRelation;
                if (DEBUG) {
                    LOGGER.debug("forced rules attachment: " + NameUtils.getSafeLabel((ReadGraph)graph, (Resource)attachmentRelation));
                }
            }
            if (DEBUG) {
                LOGGER.debug("decided attachment: " + NameUtils.getSafeLabel((ReadGraph)graph, (Resource)attachmentRelation));
            }
            IElement te = (IElement)graph.syncRequest(DiagramRequests.getElement(canvas, diagram, terminalElement, null));
            ElementUtils.getElementBounds((IElement)te, (Rectangle2D)bounds);
            Shape shp = org.simantics.g2d.utils.GeometryUtils.transformShape((Shape)bounds, (AffineTransform)terminalTr);
            bounds.setFrame(shp.getBounds2D());
            GeometryUtils.expandRectangle((Rectangle2D)bounds, (double)2.0);
            minx = bounds.getMinX();
            miny = bounds.getMinY();
            maxx = bounds.getMaxX();
            maxy = bounds.getMaxY();
            ResourceTerminal rt = new ResourceTerminal(terminal);
            TerminalLayout tl = (TerminalLayout)te.getElementClass().getSingleItem(TerminalLayout.class);
            AffineTransform terminalPos = tl.getTerminalPosition(element, (Topology.Terminal)rt);
            if (terminalPos != null) {
                terminalTr.concatenate(terminalPos);
                x = terminalTr.getTranslateX();
                y = terminalTr.getTranslateY();
                if (DEBUG) {
                    LOGGER.debug("terminalPos/Tr: " + terminalPos + ", " + terminalTr);
                }
            }
            if ((allowedDirections = (Integer)graph.getPossibleRelatedValue(terminal, DIA.Terminal_AllowedDirections, (Binding)Bindings.INTEGER)) != null) {
                direction |= allowedDirections.intValue();
                direction = RouteGraphUtils.rotateDirection(direction, terminalTr);
            } else {
                direction |= RouteGraphConnectionClass.shortestDirectionOutOfBounds(x, y, bounds);
            }
            if (backendConnections != null) {
                backendConnections.add(new BackendConnection(RouteGraphUtils.toEdgeEnd(graph, attachmentRelation, EdgeVisuals.EdgeEnd.Begin, DIA), terminalElement, terminal));
            }
            if (direction == 0) {
                direction = 15;
            }
            if (((Boolean)graph.getRelatedValue(connector, DIA.Connector_straight, (Binding)Bindings.BOOLEAN)).booleanValue()) {
                direction |= 0x10;
            }
            if (DEBUG) {
                LOGGER.debug("load line style: " + NameUtils.getSafeLabel((ReadGraph)graph, (Resource)attachmentRelation));
            }
            ILineEndStyle endStyle = RouteGraphUtils.loadLineEndStyle(graph, attachmentRelation, connectionType, TAIL);
            RouteTerminal routeTerminal = rg.addTerminal(x, y, minx, miny, maxx, maxy, direction, endStyle, (RouteTerminalPosition)new RouteTerminalPositionImpl(diagram, diagramDataElementMap, terminalElement, terminalElementTransform, tl, (Topology.Terminal)rt));
            routeTerminal.setData(RouteGraphConnection.serialize((ServiceLocator)graph, connector));
            nodeByData.put(connector, routeTerminal);
            for (Resource connectedTo : graph.getObjects(connector, DIA.AreConnected)) {
                links.add(new EdgeResource(connectedTo, connector));
            }
        }
        for (EdgeResource link : links) {
            RouteNode n1 = (RouteNode)nodeByData.get(link.first());
            RouteNode n2 = (RouteNode)nodeByData.get(link.second());
            if (n1 == null || n2 == null) {
                LOGGER.warn("Stray connection link found: " + link.toString(graph));
                continue;
            }
            rg.link(n1, n2);
        }
        return rg;
    }

    public static EdgeVisuals.EdgeEnd toEdgeEnd(ReadGraph graph, Resource attachmentRelation, EdgeVisuals.EdgeEnd defaultValue, DiagramResource DIA) throws DatabaseException {
        if (graph.isSubrelationOf(attachmentRelation, DIA.HasTailConnector)) {
            return EdgeVisuals.EdgeEnd.Begin;
        }
        if (graph.isSubrelationOf(attachmentRelation, DIA.HasHeadConnector)) {
            return EdgeVisuals.EdgeEnd.End;
        }
        return defaultValue;
    }

    public static Resource resolveFlagAttachment(ReadGraph graph, Resource connection, Resource flag, IModelingRules modelingRules, DiagramResource DIA) throws DatabaseException {
        FlagClass.Type type = RouteGraphUtils.resolveFlagType(graph, connection, flag, modelingRules, DIA);
        if (type != null) {
            switch (type) {
                case In: {
                    return DIA.HasPlainConnector;
                }
                case Out: {
                    return DIA.HasArrowConnector;
                }
            }
        }
        return null;
    }

    private static FlagClass.Type resolveFlagType(ReadGraph graph, Resource connection, Resource flag, IModelingRules modelingRules, DiagramResource DIA) throws DatabaseException {
        return RouteGraphUtils.readFlagType(graph, flag, DIA);
    }

    private static FlagClass.Type readFlagType(ReadGraph graph, Resource flag, DiagramResource DIA) throws DatabaseException {
        Resource flagType = graph.getPossibleObject(flag, DIA.HasFlagType);
        FlagClass.Type type = DiagramGraphUtil.toFlagType(DIA, flagType);
        return type;
    }

    public static Statement findTerminalStatement(ReadGraph graph, Resource connection, Resource connector, StructuralResource2 STR) throws DatabaseException {
        for (Statement stm : graph.getStatements(connector, STR.Connects)) {
            if (connection.equals(stm.getObject())) continue;
            return stm;
        }
        return null;
    }

    public static Resource getInverseAttachment(ReadGraph graph, Resource attachmentRelation, DiagramResource DIA) throws DatabaseException {
        Resource inverse = graph.getPossibleObject(attachmentRelation, DIA.HasInverseAttachment);
        if (inverse != null) {
            return inverse;
        }
        if (graph.isSubrelationOf(attachmentRelation, DIA.HasHeadConnector)) {
            return DIA.HasPlainConnector;
        }
        if (graph.isSubrelationOf(attachmentRelation, DIA.HasTailConnector)) {
            return DIA.HasArrowConnector;
        }
        return null;
    }

    public static ILineEndStyle loadLineEndStyle(ReadGraph graph, Resource attachmentRelation, ILineEndStyle defaultValue) throws DatabaseException {
        ILineEndStyle style = (ILineEndStyle)graph.syncRequest((Read)new LineEndStyle(attachmentRelation), (Listener)TransientCacheListener.instance());
        return style != null ? style : defaultValue;
    }

    public static ILineEndStyle loadLineEndStyle(ReadGraph graph, Resource attachmentRelation, Resource connectionType, ILineEndStyle defaultValue) throws DatabaseException {
        if (connectionType != null) {
            ILineEndStyle style = (ILineEndStyle)graph.syncRequest((Read)new LineEndStyleWithType(attachmentRelation, connectionType), (Listener)TransientCacheListener.instance());
            return style != null ? style : defaultValue;
        }
        ILineEndStyle style = (ILineEndStyle)graph.syncRequest((Read)new LineEndStyle(attachmentRelation), (Listener)TransientCacheListener.instance());
        return style != null ? style : defaultValue;
    }

    private static ILineEndStyle loadLineEndStyle0(ReadGraph graph, Resource attachmentRelation) throws DatabaseException {
        ILineEndStyle style = (ILineEndStyle)graph.getPossibleAdapter(attachmentRelation, ILineEndStyle.class);
        if (style != null) {
            return style;
        }
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        if (graph.isSubrelationOf(attachmentRelation, DIA.HasHeadConnector)) {
            return HEAD;
        }
        if (graph.isSubrelationOf(attachmentRelation, DIA.HasTailConnector)) {
            return TAIL;
        }
        return null;
    }

    private static ILineEndStyle loadLineEndStyle0(ReadGraph graph, Resource attachmentRelation, Resource connectionType) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        if (graph.isSubrelationOf(attachmentRelation, DIA.HasHeadConnector) && connectionType != null) {
            G2DResource G2D = G2DResource.getInstance((ReadGraph)graph);
            Resource end = graph.getPossibleObject(connectionType, G2D.HasEndArrow);
            if (end != null) {
                float[] col;
                Double space;
                Double widthRatio;
                Double size = (Double)graph.getPossibleRelatedValue(end, G2D.HasSize, (Binding)Bindings.DOUBLE);
                if (size == null) {
                    size = 0.0;
                }
                if ((widthRatio = (Double)graph.getPossibleRelatedValue(end, G2D.HasWidthRatio, (Binding)Bindings.DOUBLE)) == null) {
                    widthRatio = 1.0;
                }
                if ((space = (Double)graph.getPossibleRelatedValue(end, G2D.HasSpace, (Binding)Bindings.DOUBLE)) == null) {
                    space = 0.0;
                }
                Resource c = graph.getPossibleObject(end, G2D.HasColor);
                Color color = null;
                if (c != null && (col = (float[])graph.getPossibleValue(c, (Binding)Bindings.FLOAT_ARRAY)) != null && col.length >= 3) {
                    color = new Color(col[0], col[1], col[2]);
                }
                return new ArrowLineEndStyle(size.doubleValue(), widthRatio * size, space.doubleValue(), color);
            }
        }
        return RouteGraphUtils.loadLineEndStyle0(graph, attachmentRelation);
    }

    public static StyledRouteGraphRenderer getRenderer(ReadGraph graph, ConnectionStyle style) throws DatabaseException {
        return (StyledRouteGraphRenderer)graph.syncRequest((Read)new Renderer(style), (Listener)TransientCacheListener.instance());
    }

    protected static ConnectionStyle readConnectionStyle(ReadGraph graph, IModelingRules modelingRules, Resource connection, StructuralResource2 STR) throws DatabaseException {
        Resource connectionType = null;
        if (modelingRules != null) {
            connectionType = modelingRules.getConnectionType(graph, connection);
        }
        if (connectionType == null) {
            connectionType = graph.getPossibleObject(connection, STR.HasConnectionType);
        }
        return connectionType != null ? RouteGraphUtils.readConnectionStyleFromConnectionType(graph, connectionType) : DEFAULT_CONNECTION_STYLE;
    }

    protected static ConnectionStyle readConnectionStyleFromConnectionType(ReadGraph graph, Resource connectionType) throws DatabaseException {
        return (ConnectionStyle)graph.syncRequest((Read)new ReadConnectionStyleFromConnectionType(connectionType), (Listener)TransientCacheListener.instance());
    }

    protected static ConnectionStyle readConnectionStyleFromConnectionType0(ReadGraph graph, Resource connectionType) throws DatabaseException {
        Stroke lineStroke;
        Color lineColor;
        ConnectionVisuals cv = null;
        if (connectionType != null) {
            cv = (ConnectionVisuals)graph.syncRequest(DiagramRequests.getConnectionVisuals(connectionType), (Listener)TransientCacheListener.instance());
        }
        Color branchPointColor = Color.BLACK;
        double branchPointRadius = cv != null && cv.branchPointRadius != null ? cv.branchPointRadius : 0.5;
        double degenerateLineLength = 0.8;
        Color color = lineColor = cv != null ? cv.toColor() : null;
        if (lineColor == null) {
            lineColor = Color.DARK_GRAY;
        }
        Stroke stroke = lineStroke = cv != null ? cv.stroke : null;
        if (lineStroke == null) {
            lineStroke = new BasicStroke(0.1f, 0, 2, 10.0f, null, 0.0f);
        }
        BasicStroke routeLineStroke = GeometryUtils.scaleStrokeWidth((Stroke)lineStroke, (float)2.0f);
        double rounding = cv.rounding == null ? 0.0 : cv.rounding;
        return new BasicConnectionStyle(lineColor, branchPointColor, branchPointRadius, lineStroke, (Stroke)routeLineStroke, degenerateLineLength, rounding);
    }

    public static void scheduleSynchronize(Session session, Resource connection, RouteGraphChangeEvent event) {
        session.asyncRequest(RouteGraphConnection.synchronizer(connection, event));
    }

    public static int rotateDirection(int direction, AffineTransform at) {
        boolean rotatedOrFlipped;
        if ((direction & 0x10) != 0) {
            return direction;
        }
        boolean bl = rotatedOrFlipped = (at.getType() & 0x58) != 0;
        if (rotatedOrFlipped) {
            double xAxisAngle = Math.atan2(at.getShearY(), at.getScaleX());
            double yAxisAngle = Math.atan2(at.getScaleY(), at.getShearX());
            int xQuadrant = RouteGraphUtils.mainQuadrant(xAxisAngle);
            int yQuadrant = RouteGraphUtils.mainQuadrant(yAxisAngle);
            int xDirMask = direction & 5;
            int yDirMask = direction & 0xA;
            int xDirMaskRotated = RouteGraphUtils.rotl4(xDirMask, xQuadrant);
            int yDirMaskRotated = RouteGraphUtils.rotl4(yDirMask, yQuadrant - 1);
            direction = xDirMaskRotated | yDirMaskRotated;
        }
        return direction;
    }

    private static int rotl4(int x, int n) {
        if ((n &= 3) == 0) {
            return x;
        }
        int hx = x & 0xFFFFFFF0;
        int lx = x & 0xF;
        int xh = lx << n & 0xF;
        int xl = lx >>> 4 - n;
        return xh | xl | hx;
    }

    private static int mainQuadrant(double theta) {
        if (theta > -0.7853981633974483 && theta <= 0.7853981633974483) {
            return 0;
        }
        if (theta > 0.7853981633974483 && theta <= 2.356194490192345) {
            return 1;
        }
        if (theta >= -2.356194490192345 && theta < -0.7853981633974483) {
            return 3;
        }
        return 2;
    }

    public static class BackendConnection {
        public final Resource node;
        public final Resource terminal;
        public final EdgeVisuals.EdgeEnd end;
        public final int hash;

        public BackendConnection(EdgeVisuals.EdgeEnd end, Resource node, Resource terminal) {
            assert (end != null);
            assert (node != null);
            assert (terminal != null);
            this.end = end;
            this.node = node;
            this.terminal = terminal;
            this.hash = this.makeHash();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof Topology.Connection)) {
                return false;
            }
            Topology.Connection other = (Topology.Connection)obj;
            return other.terminal == this.terminal && other.node == this.node && other.end == this.end;
        }

        private int makeHash() {
            int result = 1;
            result = 31 * result + this.end.hashCode();
            result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
            result = 31 * result + (this.terminal == null ? 0 : this.terminal.hashCode());
            return result;
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return "BackendConnection[node=" + this.node + ", terminal=" + this.terminal + ", end=" + this.end + "]";
        }
    }

    public static class LineEndStyle
    extends UnaryRead<Resource, ILineEndStyle> {
        public LineEndStyle(Resource attachmentRelation) {
            super((Object)attachmentRelation);
        }

        public ILineEndStyle perform(ReadGraph graph) throws DatabaseException {
            return RouteGraphUtils.loadLineEndStyle0(graph, (Resource)this.parameter);
        }
    }

    public static class LineEndStyleWithType
    extends ResourceRead2<ILineEndStyle> {
        public LineEndStyleWithType(Resource attachmentRelation, Resource connectionType) {
            super(attachmentRelation, connectionType);
        }

        public ILineEndStyle perform(ReadGraph graph) throws DatabaseException {
            return RouteGraphUtils.loadLineEndStyle0(graph, this.resource, this.resource2);
        }
    }

    public static class ReadConnectionStyleFromConnectionType
    extends UnaryRead<Resource, ConnectionStyle> {
        public ReadConnectionStyleFromConnectionType(Resource connectionType) {
            super((Object)connectionType);
        }

        public ConnectionStyle perform(ReadGraph graph) throws DatabaseException {
            return RouteGraphUtils.readConnectionStyleFromConnectionType0(graph, (Resource)this.parameter);
        }
    }

    public static class Renderer
    extends UnaryRead<ConnectionStyle, StyledRouteGraphRenderer> {
        public Renderer(ConnectionStyle style) {
            super((Object)style);
        }

        public StyledRouteGraphRenderer perform(ReadGraph graph) throws DatabaseException {
            return new StyledRouteGraphRenderer((ConnectionStyle)this.parameter);
        }
    }

    private static class RouteTerminalPositionImpl
    implements RouteTerminalPosition {
        private IDiagram diagram;
        private DataElementMap dataElementMap;
        private Resource element;
        private AffineTransform elementTransform;
        private TerminalLayout terminalLayout;
        private Topology.Terminal elementTerminal;
        private transient AffineTransform lastTerminalTr;
        private transient AffineTransform transform;

        public RouteTerminalPositionImpl(IDiagram diagram, DataElementMap dem, Resource element, AffineTransform elementTransform, TerminalLayout terminalLayout, Topology.Terminal terminal) {
            this.diagram = diagram;
            this.dataElementMap = dem;
            this.element = element;
            this.elementTransform = elementTransform;
            this.terminalLayout = terminalLayout;
            this.elementTerminal = terminal;
        }

        public AffineTransform getTransform() {
            AffineTransform terminalTr;
            IElement actualElement = this.dataElementMap.getElement(this.diagram, (Object)this.element);
            AffineTransform affineTransform = terminalTr = actualElement != null ? this.terminalLayout.getTerminalPosition(actualElement, this.elementTerminal) : null;
            if (terminalTr == null) {
                return this.elementTransform;
            }
            AffineTransform result = this.transform;
            AffineTransform lastTerminalTr = this.lastTerminalTr;
            if (lastTerminalTr != null) {
                if (terminalTr.equals(lastTerminalTr)) {
                    return result;
                }
                lastTerminalTr.setTransform(terminalTr);
            } else {
                lastTerminalTr = this.lastTerminalTr = new AffineTransform(terminalTr);
                result = this.transform = new AffineTransform();
            }
            result.setTransform(this.elementTransform);
            result.concatenate(terminalTr);
            return result;
        }
    }
}

