/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.preferences;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.history.csv.ColumnSeparator;
import org.simantics.history.csv.DecimalSeparator;
import org.simantics.history.csv.ExportInterpolation;

public class CSVPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private ComboFieldEditor fDecimalSeparatorEditor = null;
    private ComboFieldEditor fColumnSeparatorEditor = null;
    private StringFieldEditor fExtensionEditor = null;
    private BooleanFieldEditor fResamplingEditor = null;
    private ComboFieldEditor fSamplingModeEditor = null;
    private StringFieldEditor fStartEditor = null;
    private StringFieldEditor fStepEditor = null;
    private IntegerFieldEditor fTimeDigitsEditor = null;
    private IntegerFieldEditor fFloatDigitsEditor = null;
    private IntegerFieldEditor fDoubleDigitsEditor = null;
    private String decimalSeparatorValue;
    private String columnSeparatorValue;

    public CSVPreferencePage() {
        super(1);
        this.setDescription("CSV import and export preferences");
        ScopedPreferenceStore pf = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.simantics.modeling");
        this.setPreferenceStore((IPreferenceStore)pf);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
    }

    public void init(IWorkbench workbench) {
    }

    protected void initialize() {
        super.initialize();
        if (this.decimalSeparatorValue.equals(this.columnSeparatorValue)) {
            this.setErrorMessage("Column and decimal separators must not be the same.");
            this.checkState();
            this.updateApplyButton();
        }
    }

    protected void createFieldEditors() {
        this.decimalSeparatorValue = this.getPreferenceStore().getString("csv.decimal.separator");
        this.columnSeparatorValue = this.getPreferenceStore().getString("csv.value.separator");
        String[][] decimalSeparators = new String[DecimalSeparator.values().length][];
        int i = 0;
        DecimalSeparator[] decimalSeparatorArray = DecimalSeparator.values();
        int n = decimalSeparatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            DecimalSeparator ds = decimalSeparatorArray[n2];
            decimalSeparators[i++] = new String[]{ds.label, ds.preference};
            ++n2;
        }
        String[][] columnSeparators = new String[ColumnSeparator.values().length][];
        i = 0;
        ColumnSeparator[] columnSeparatorArray = ColumnSeparator.values();
        int n3 = columnSeparatorArray.length;
        n = 0;
        while (n < n3) {
            ColumnSeparator cs = columnSeparatorArray[n];
            columnSeparators[i++] = new String[]{cs.label, cs.preference};
            ++n;
        }
        this.fDecimalSeparatorEditor = new ComboFieldEditor("csv.decimal.separator", "Decimal separator", decimalSeparators, this.getFieldEditorParent()){

            public boolean isValid() {
                return !CSVPreferencePage.this.decimalSeparatorValue.equals(CSVPreferencePage.this.columnSeparatorValue);
            }
        };
        this.addField((FieldEditor)this.fDecimalSeparatorEditor);
        this.fColumnSeparatorEditor = new ComboFieldEditor("csv.value.separator", "Column separator", columnSeparators, this.getFieldEditorParent()){

            public boolean isValid() {
                return !CSVPreferencePage.this.decimalSeparatorValue.equals(CSVPreferencePage.this.columnSeparatorValue);
            }
        };
        this.addField((FieldEditor)this.fColumnSeparatorEditor);
        this.fExtensionEditor = new StringFieldEditor("csv.file.extension", "File extension", this.getFieldEditorParent());
        this.addField((FieldEditor)this.fExtensionEditor);
        this.fResamplingEditor = new BooleanFieldEditor("csv.resample", "Resampling", this.getFieldEditorParent());
        this.addField((FieldEditor)this.fResamplingEditor);
        this.fSamplingModeEditor = new ComboFieldEditor("csv.sampling.mode", "Sampling mode", (String[][])new String[][]{{ExportInterpolation.LINEAR_INTERPOLATION.label, ExportInterpolation.LINEAR_INTERPOLATION.preference}, {ExportInterpolation.PREVIOUS_SAMPLE.label, ExportInterpolation.PREVIOUS_SAMPLE.preference}}, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fSamplingModeEditor);
        this.fStartEditor = new StringFieldEditor("csv.start", "Start time (s)", this.getFieldEditorParent()){

            protected boolean doCheckState() {
                String text = this.getTextControl().getText();
                if (text == null || text.isEmpty()) {
                    return true;
                }
                try {
                    double number = Double.parseDouble(text);
                    return number > 0.0;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
        };
        this.fStartEditor.setEmptyStringAllowed(true);
        this.fStartEditor.setErrorMessage("Enter valid start time value (s)");
        this.fStepEditor = new StringFieldEditor("csv.step", "Step size (s)", this.getFieldEditorParent()){

            protected boolean doCheckState() {
                String text = this.getTextControl().getText();
                if (text == null || text.isEmpty()) {
                    return true;
                }
                try {
                    double number = Double.parseDouble(text);
                    return number > 0.0;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
        };
        this.fStepEditor.setEmptyStringAllowed(true);
        this.fStepEditor.setErrorMessage("Enter valid time step value (s)");
        this.addField((FieldEditor)this.fStepEditor);
        Group significantDigitsGroup = new Group(this.getFieldEditorParent(), 0);
        significantDigitsGroup.setText("Significant digits");
        significantDigitsGroup.setToolTipText("Control the Amount of Significant Digits in Exported Numbers");
        GridDataFactory.fillDefaults().indent(0, 5).span(2, 1).applyTo((Control)significantDigitsGroup);
        this.fTimeDigitsEditor = new IntegerFieldEditor("csv.format.time.digits", "Time stamps", (Composite)significantDigitsGroup, 2);
        this.fTimeDigitsEditor.setValidRange(1, 15);
        this.addField((FieldEditor)this.fTimeDigitsEditor);
        this.fFloatDigitsEditor = new IntegerFieldEditor("csv.format.float.digits", "Single precision floating point", (Composite)significantDigitsGroup, 1);
        this.fFloatDigitsEditor.setValidRange(1, 7);
        this.addField((FieldEditor)this.fFloatDigitsEditor);
        this.fDoubleDigitsEditor = new IntegerFieldEditor("csv.format.double.digits", "Double precision floating point", (Composite)significantDigitsGroup, 2);
        this.fDoubleDigitsEditor.setValidRange(1, 15);
        this.addField((FieldEditor)this.fDoubleDigitsEditor);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)significantDigitsGroup);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_value")) {
            Object source = event.getSource();
            boolean validate = false;
            if (source == this.fDecimalSeparatorEditor) {
                this.decimalSeparatorValue = (String)event.getNewValue();
                validate = true;
            } else if (source == this.fColumnSeparatorEditor) {
                this.columnSeparatorValue = (String)event.getNewValue();
                validate = true;
            }
            if (validate) {
                if (this.decimalSeparatorValue.equals(this.columnSeparatorValue)) {
                    this.setErrorMessage("Column and decimal separators must not be the same.");
                } else {
                    this.setErrorMessage(null);
                }
                this.checkState();
                this.updateApplyButton();
            }
        }
        super.propertyChange(event);
    }
}

