/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.actions;

import gnu.trove.set.hash.THashSet;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.CancelTransactionException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.request.WriteInterface;
import org.simantics.modeling.flags.MergeFlags;
import org.simantics.utils.ui.ExceptionUtils;

public class MergeFlagsAction
implements ActionFactory {
    public Runnable create(Object target) {
        if (!(target instanceof Resource)) {
            return null;
        }
        Resource composite = (Resource)target;
        final THashSet composites = new THashSet();
        composites.add((Object)composite);
        return new Runnable(){

            @Override
            public void run() {
                try {
                    IRunnableWithProgress runnable = new IRunnableWithProgress(){

                        public void run(final IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            final SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)"Merge Flags", (int)1000);
                            try {
                                try {
                                    Simantics.getSession().sync((WriteInterface)new WriteRequest(){

                                        public void perform(WriteGraph graph) throws DatabaseException {
                                            graph.markUndoPoint();
                                            SubMonitor expand = submonitor.newChild(10);
                                            expand.subTask("Expand Composite Set");
                                            MergeFlags.expandCompositeSet((ReadGraph)graph, (THashSet)composites);
                                            if (monitor.isCanceled()) {
                                                throw new CancelTransactionException();
                                            }
                                            expand.done();
                                            SubMonitor collect = submonitor.newChild(490);
                                            collect.subTask("Collect flags");
                                            collect.setWorkRemaining(composites.size());
                                            ArrayList groups = new ArrayList();
                                            for (Resource composite : composites) {
                                                MergeFlags.collectFlagGroupsInComposite((ReadGraph)graph, (Resource)composite, groups);
                                                if (monitor.isCanceled()) {
                                                    throw new CancelTransactionException();
                                                }
                                                collect.worked(1);
                                            }
                                            collect.done();
                                            SubMonitor merge = submonitor.newChild(500);
                                            merge.subTask("Merge collected flags");
                                            merge.setWorkRemaining(composites.size());
                                            for (ArrayList group : groups) {
                                                MergeFlags.merge((WriteGraph)graph, (List)group);
                                                if (monitor.isCanceled()) {
                                                    throw new CancelTransactionException();
                                                }
                                                merge.worked(1);
                                            }
                                            merge.done();
                                        }
                                    });
                                }
                                catch (CancelTransactionException cancelTransactionException) {
                                    monitor.done();
                                }
                                catch (DatabaseException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                            finally {
                                monitor.done();
                            }
                        }
                    };
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    new ProgressMonitorDialog(shell).run(true, true, runnable);
                }
                catch (InvocationTargetException e) {
                    ExceptionUtils.logAndShowError((Throwable)e.getTargetException());
                }
                catch (InterruptedException interruptedException) {}
            }
        };
    }
}

