/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.selectionview.function;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FontDialog;
import org.simantics.Simantics;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.content.Labeler;
import org.simantics.common.color.Color;
import org.simantics.common.format.Formatter;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.mutable.MutableStringBinding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.parser.DataValuePrinter;
import org.simantics.databoard.parser.repository.DataTypeSyntaxError;
import org.simantics.databoard.parser.repository.DataValueRepository;
import org.simantics.databoard.primitives.MutableString;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.ObjectUtils;
import org.simantics.datatypes.literal.Font;
import org.simantics.datatypes.literal.RGB;
import org.simantics.db.Metadata;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.EnumerationMap;
import org.simantics.db.common.request.InstanceEnumerationMap;
import org.simantics.db.common.request.IsEnumeratedValue;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.ValueAccessor;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.reflection.annotations.SCLValue;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.selectionview.SelectionInput;
import org.simantics.selectionview.SelectionViewResources;
import org.simantics.selectionview.StandardSelectionInput;
import org.simantics.ui.colors.Colors;
import org.simantics.ui.fonts.Fonts;
import org.simantics.ui.selection.WorkbenchSelectionElement;
import org.simantics.ui.selection.WorkbenchSelectionUtils;
import org.simantics.utils.datastructures.collections.CollectionUtils;
import org.simantics.utils.ui.AdaptionUtils;
import org.simantics.utils.ui.ErrorLogger;
import org.simantics.utils.ui.ISelectionUtils;

public class All {
    private static final Binding datatype_binging = Bindings.getBindingUnchecked(Datatype.class);
    @SCLValue(type="ValueAccessor")
    public static ValueAccessor displayUnitValueAccessor = new ValueAccessor(){

        public Object getValue(ReadGraph graph, Variable context) throws DatabaseException {
            return Variables.getPossibleUnit((ReadGraph)graph, (Variable)context.getParent(graph));
        }

        public Object getValue(ReadGraph graph, Variable context, Binding binding) throws DatabaseException {
            String value;
            block4: {
                value = Variables.getPossibleUnit((ReadGraph)graph, (Variable)context.getParent(graph));
                if (value != null) break block4;
                return null;
            }
            try {
                Binding srcBinding = Bindings.OBJECT.getContentBinding((Object)value);
                return Bindings.adapt((Object)value, (Binding)srcBinding, (Binding)binding);
            }
            catch (AdaptException e) {
                throw new DatabaseException((Throwable)e);
            }
            catch (BindingException e) {
                throw new DatabaseException((Throwable)e);
            }
        }

        public void setValue(WriteGraph graph, Variable context, Object value) throws DatabaseException {
            throw new UnsupportedOperationException();
        }

        public void setValue(WriteGraph graph, Variable context, Object value, Binding binding) throws DatabaseException {
            throw new UnsupportedOperationException();
        }

        public Datatype getDatatype(ReadGraph graph, Variable context) throws DatabaseException {
            return org.simantics.db.layer0.function.All.getDatatypeFromValue((ReadGraph)graph, (Variable)context);
        }
    };
    @SCLValue(type="ValueAccessor")
    public static ValueAccessor displayPropertyValueAccessor = new ValueAccessor(){

        public Object getValue(ReadGraph graph, Variable context) throws DatabaseException {
            return this.getValue(graph, context, (Binding)Bindings.STRING);
        }

        public Object getValue(ReadGraph graph, Variable context, Binding binding) throws DatabaseException {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Variable property = context.getParent(graph);
            Resource predicate = property.getPossiblePredicateResource(graph);
            if (predicate == null) {
                return property.getName(graph);
            }
            String value = (String)graph.getPossibleRelatedValue2(predicate, L0.HasLabel, (Binding)Bindings.STRING);
            if (value == null) {
                value = (String)graph.getRelatedValue(predicate, L0.HasName, (Binding)Bindings.STRING);
            }
            try {
                return Bindings.adapt((Object)value, (Binding)binding, (Binding)Bindings.STRING);
            }
            catch (AdaptException e) {
                throw new DatabaseException((Throwable)e);
            }
        }

        public void setValue(WriteGraph graph, Variable context, Object value) throws DatabaseException {
            throw new UnsupportedOperationException();
        }

        public void setValue(WriteGraph graph, Variable context, Object value, Binding binding) throws DatabaseException {
            throw new UnsupportedOperationException();
        }

        public Datatype getDatatype(ReadGraph graph, Variable context) throws DatabaseException {
            return Datatypes.STRING;
        }
    };
    @SCLValue(type="ValueAccessor")
    public static ValueAccessor displayValueValueAccessor = new ValueAccessor(){

        public Object getValue(ReadGraph graph, Variable context) throws DatabaseException {
            return this.getValue(graph, context, (Binding)Bindings.STRING);
        }

        public boolean isPrimitive(Datatype dt) {
            return Datatypes.STRING.equals((Object)dt);
        }

        private String possibleExpression(ReadGraph graph, Variable variable) throws DatabaseException {
            String expression;
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Resource object = variable.getPossibleRepresents(graph);
            if (object != null && graph.isInstanceOf(object, L0.SCLValue) && (expression = (String)graph.getPossibleRelatedValue(object, L0.SCLValue_expression)) != null) {
                return "=" + expression;
            }
            return null;
        }

        public Object getValue(ReadGraph graph, Variable context, Binding _binding) throws DatabaseException {
            Variable property = context.getParent(graph);
            String expression = this.possibleExpression(graph, property);
            if (expression != null) {
                return expression;
            }
            Object value = null;
            Resource formatter = (Resource)property.getPossiblePropertyValue(graph, "HasFormatter");
            if (formatter != null) {
                Formatter fmt = (Formatter)graph.adaptContextual(formatter, (Object)property, Variable.class, Formatter.class);
                value = fmt.format(property.getValue(graph));
            }
            if (value == null) {
                SelectionViewResources SEL = SelectionViewResources.getInstance((ReadGraph)graph);
                Function1 formatterFunction = (Function1)property.getPossiblePropertyValue(graph, SEL.formatter);
                if (formatterFunction != null) {
                    value = formatterFunction.apply(property.getValue(graph));
                }
            }
            if (value == null) {
                Datatype dt;
                Variant variant = property.getVariantValue(graph);
                value = variant.getValue();
                Binding binding = variant.getBinding();
                if (binding != null && (dt = binding.type()) != null && !this.isPrimitive(dt)) {
                    try {
                        value = DataValuePrinter.writeValueSingleLine((Binding)binding, (Object)value);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (BindingException e) {
                        e.printStackTrace();
                    }
                }
            }
            try {
                return Bindings.adapt((Object)(value != null ? value.toString() : "null"), (Binding)_binding, (Binding)Bindings.STRING);
            }
            catch (AdaptException e) {
                throw new DatabaseException((Throwable)e);
            }
        }

        public void setValue(WriteGraph graph, Variable context, Object value) throws DatabaseException {
            try {
                Binding binding = Bindings.getBinding(value.getClass());
                this.setValue(graph, context, value, binding);
            }
            catch (BindingConstructionException e) {
                throw new DatabaseException((Throwable)e);
            }
        }

        public void setValue(WriteGraph graph, Variable context, Object _value, Binding _binding) throws DatabaseException {
            try {
                if (!(_value instanceof String)) {
                    throw new DatabaseException("setValue for HasDisplayValue only accepts String (got " + _value.getClass().getSimpleName() + ")");
                }
                String text = (String)_value;
                if (text.startsWith("=")) {
                    Variable property = context.getParent((ReadGraph)graph);
                    Layer0Utils.setExpression((WriteGraph)graph, (Variable)property, (String)text, (Resource)ModelingResources.getInstance((ReadGraph)graph).SCLValue);
                    return;
                }
                String parsedLabel = (String)_value;
                Object value = parsedLabel;
                Datatype type = context.getParent((ReadGraph)graph).getPossibleDatatype((ReadGraph)graph);
                if (type != null) {
                    Binding binding = Bindings.getBinding((Datatype)type);
                    if (binding instanceof StringBinding) {
                        value = binding instanceof MutableStringBinding ? new MutableString(parsedLabel) : parsedLabel;
                    } else {
                        if (binding instanceof NumberBinding) {
                            parsedLabel = parsedLabel.replace(",", ".");
                        }
                        value = binding.parseValue(parsedLabel, new DataValueRepository());
                    }
                    context.getParent((ReadGraph)graph).setValue(graph, value, binding);
                } else {
                    context.getParent((ReadGraph)graph).setValue(graph, value);
                }
                CommentMetadata cm = (CommentMetadata)graph.getMetadata(CommentMetadata.class);
                graph.addMetadata((Metadata)cm.add("Set value " + ObjectUtils.toString((Object)value)));
            }
            catch (DataTypeSyntaxError e) {
                throw new DatabaseException((Throwable)e);
            }
            catch (BindingException e) {
                throw new DatabaseException((Throwable)e);
            }
        }

        public Datatype getDatatype(ReadGraph graph, Variable context) throws DatabaseException {
            return Datatypes.STRING;
        }
    };

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object colorModifier(ReadGraph graph, Resource resource, final Variable context) throws DatabaseException {
        return new Labeler.DialogModifier(){

            public String getValue() {
                return null;
            }

            public String isValid(String label) {
                return null;
            }

            public void modify(final String label) {
                Simantics.getSession().async((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Variable displayValue = context.getParent((ReadGraph)graph);
                        displayValue.setValue(graph, (Object)label, RGB.Integer.BINDING);
                    }
                });
            }

            public String query(Object parentControl, Object controlItem, int columnIndex, NodeContext context2, Consumer<String> applyCallback) {
                RGB rgb;
                Control ctrl = (Control)parentControl;
                RGB initialValue = null;
                final Variable v = (Variable)AdaptionUtils.adaptToSingle((Object)context2, Variable.class);
                if (v != null) {
                    try {
                        RGB.Integer rgb2 = (RGB.Integer)Simantics.getSession().syncRequest((Read)new UniqueRead<RGB.Integer>(){

                            public RGB.Integer perform(ReadGraph graph) throws DatabaseException {
                                return (RGB.Integer)v.getPossibleValue(graph, RGB.Integer.BINDING);
                            }
                        });
                        if (rgb2 != null) {
                            initialValue = Colors.rgb((Color)rgb2);
                        }
                    }
                    catch (DatabaseException e) {
                        ErrorLogger.defaultLogError((Throwable)e);
                    }
                }
                ColorDialog dialog = new ColorDialog(ctrl.getShell());
                if (initialValue != null) {
                    dialog.setRGB(initialValue);
                }
                if ((rgb = dialog.open()) != null) {
                    applyCallback.accept("(" + rgb.red + "," + rgb.green + "," + rgb.blue + ")");
                }
                return null;
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> Variable -> b")
    public static Object fontModifier(ReadGraph graph, Resource resource, final Variable context) throws DatabaseException {
        return new Labeler.DialogModifier(){

            public String getValue() {
                return null;
            }

            public String isValid(String label) {
                return null;
            }

            public void modify(final String label) {
                Simantics.getSession().async((WriteInterface)new WriteRequest(){

                    public void perform(WriteGraph graph) throws DatabaseException {
                        Variable displayValue = context.getParent((ReadGraph)graph);
                        displayValue.setValue(graph, (Object)label, Font.BINDING);
                    }
                });
            }

            public String query(Object parentControl, Object controlItem, int columnIndex, NodeContext context2, Consumer<String> applyCallback) {
                FontData font;
                Control ctrl = (Control)parentControl;
                FontData[] initialValue = null;
                final Variable v = (Variable)AdaptionUtils.adaptToSingle((Object)context2, Variable.class);
                if (v != null) {
                    try {
                        Font font2 = (Font)Simantics.getSession().syncRequest((Read)new UniqueRead<Font>(){

                            public Font perform(ReadGraph graph) throws DatabaseException {
                                return (Font)v.getPossibleValue(graph, Font.BINDING);
                            }
                        });
                        if (font2 != null) {
                            initialValue = new FontData[]{Fonts.swtFontData((Font)font2)};
                        }
                    }
                    catch (DatabaseException e) {
                        ErrorLogger.defaultLogError((Throwable)e);
                    }
                }
                FontDialog dialog = new FontDialog(ctrl.getShell());
                if (initialValue != null) {
                    dialog.setFontList(initialValue);
                }
                if ((font = dialog.open()) != null) {
                    applyCallback.accept("(\"" + font.getName() + "\"," + font.getHeight() + ",\"" + Fonts.fromSwtStyle((int)font.getStyle()) + "\")");
                }
                return null;
            }
        };
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> b")
    public static Object getEnumerationValues(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        if (context instanceof Variable) {
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            Variable parameter = ((Variable)context).browse(graph, "..");
            Resource parameterResource = parameter.getRepresents(graph);
            if (((Boolean)graph.sync((ReadInterface)new IsEnumeratedValue(parameterResource))).booleanValue()) {
                Map map = (Map)graph.sync((ReadInterface)new InstanceEnumerationMap(parameterResource));
                return new ArrayList(map.keySet());
            }
            if (graph.isInstanceOf(parameterResource, L0.Boolean)) {
                return CollectionUtils.toList((Object[])new String[]{"true", "false"});
            }
        }
        return null;
    }

    @SCLValue(type="ReadGraph -> Resource -> a -> b")
    public static Object getPropertyChildName(ReadGraph graph, Resource resource, Object context) throws DatabaseException {
        if (context instanceof Variable) {
            Variable variable = (Variable)context;
            String label = (String)variable.getParent(graph).getPossiblePropertyValue(graph, "HasLabel", (Binding)Bindings.STRING);
            if (label != null) {
                return label;
            }
            return variable.getParent(graph).getName(graph);
        }
        throw new DatabaseException("Unknown context " + context);
    }

    @SCLValue(type="WriteGraph -> Variable -> a -> b -> String")
    public static String inputModifier(WriteGraph graph, Variable variable, Object value, Object _binding) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        Variable parent = variable.getParent((ReadGraph)graph);
        Resource property = variable.getPredicateResource((ReadGraph)graph);
        Resource container = parent.getRepresents((ReadGraph)graph);
        if (container == null) {
            return null;
        }
        if (property == null) {
            return null;
        }
        Statement object = graph.getPossibleStatement(container, property);
        if (object == null) {
            return null;
        }
        Resource objectResource = object.getObject();
        if (((Boolean)graph.sync((ReadInterface)new IsEnumeratedValue(objectResource))).booleanValue()) {
            Resource type = graph.getSingleObject(objectResource, L0.PartOf);
            Map enumMap = (Map)graph.syncRequest((Read)new EnumerationMap(type));
            Resource newLiteral = (Resource)enumMap.get(value);
            graph.deny(container, property, objectResource);
            graph.claim(container, property, newLiteral);
            return null;
        }
        Resource newType = Layer0Utils.getPossibleLiteralType((ReadGraph)graph, (Variable)variable);
        if (newType == null) {
            Type type = Layer0Utils.getSCLType((ReadGraph)graph, (Variable)variable);
            if (Types.canonical((Type)type) instanceof TVar) {
                newType = Layer0Utils.inferLiteralTypeFromString((ReadGraph)graph, (String)value.toString());
            } else {
                throw new DatabaseException("Failed to find type for property " + NameUtils.getSafeName((ReadGraph)graph, (Resource)property));
            }
        }
        boolean correctType = graph.getPossibleType(objectResource, newType) != null;
        boolean asserted = object.isAsserted(container);
        if (asserted || !correctType) {
            if (correctType) {
                Statement dt = graph.getPossibleStatement(objectResource, L0.HasDataType);
                Datatype custom = dt.isAsserted(objectResource) ? null : (Datatype)graph.getValue(dt.getObject(), datatype_binging);
                objectResource = graph.newResource();
                graph.claim(objectResource, L0.InstanceOf, null, newType);
                graph.claim(container, property, objectResource);
                if (custom != null) {
                    String currentValueType;
                    String newValueType = Layer0Utils.getSCLType((Datatype)custom);
                    if (!newValueType.equals(currentValueType = (String)graph.getPossibleRelatedValue(objectResource, L0.HasValueType, (Binding)Bindings.STRING))) {
                        graph.addLiteral(objectResource, L0.HasValueType, L0.HasValueType_Inverse, L0.String, (Object)newValueType, (Binding)Bindings.STRING);
                    }
                    graph.addLiteral(objectResource, L0.HasDataType, L0.HasDataType_Inverse, L0.DataType, (Object)custom, datatype_binging);
                }
            } else if (newType != null) {
                if (!correctType && !asserted) {
                    graph.deny(container, property, objectResource);
                }
                objectResource = graph.newResource();
                graph.claim(objectResource, L0.InstanceOf, newType);
                graph.claim(container, property, objectResource);
            }
        }
        Datatype datatype = variable.getDatatype((ReadGraph)graph);
        Binding binding = (Binding)_binding;
        Layer0Utils.claimAdaptedValue((WriteGraph)graph, (Resource)objectResource, (Object)value, (Binding)binding, (Datatype)datatype);
        return null;
    }

    @SCLValue(type="ReadGraph -> a -> Resource")
    public static Resource singleResourceTransformation(ReadGraph graph, Object input) throws DatabaseException {
        return WorkbenchSelectionUtils.getPossibleResource((RequestProcessor)graph, (Object)input);
    }

    @SCLValue(type="ReadGraph -> a -> Variable")
    public static Variable singleVariableTransformation(ReadGraph graph, Object input) throws DatabaseException {
        Variable single = WorkbenchSelectionUtils.getPossibleVariable((RequestProcessor)graph, (Object)input);
        if (single != null) {
            return single;
        }
        return (Variable)ISelectionUtils.filterSingleSelection((Object)input, Variable.class);
    }

    @SCLValue(type="ReadGraph -> a -> Variable")
    public static Variable singleResourceToVariableTransformation(ReadGraph graph, Object input) throws DatabaseException {
        Resource r = WorkbenchSelectionUtils.getPossibleResource((RequestProcessor)graph, (Object)input);
        if (r == null) {
            return null;
        }
        return Variables.getPossibleVariable((ReadGraph)graph, (Resource)r);
    }

    @SCLValue(type="ReadGraph -> a -> SelectionInput")
    public static SelectionInput standardSelectionInputTransformation(ReadGraph graph, Object input) throws DatabaseException {
        WorkbenchSelectionElement wse = WorkbenchSelectionUtils.getPossibleSelectionElement((Object)input);
        if (wse == null) {
            return null;
        }
        return new StandardSelectionInput(wse);
    }
}

