/*
 * Decompiled with CFR 0.152.
 */
package net.jpountz.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class ChecksumUtil {
    private static byte[] computeSum(InputStream in) throws IOException {
        MessageDigest md;
        if (in == null) {
            throw new IllegalArgumentException("Input cannot be null!");
        }
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new Error("MD5 digest must be supported by JVM");
        }
        byte[] data = new byte[65536];
        int read;
        while ((read = in.read(data)) != -1) {
            md.update(data, 0, read);
        }
        return md.digest();
    }

    public static byte[] computeSum(Path p) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream in = Files.newInputStream(p, new OpenOption[0]);){
            return ChecksumUtil.computeSum(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static byte[] computeSum(URL url) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream in = url.openStream();){
            return ChecksumUtil.computeSum(in);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

