/*
 * Decompiled with CFR 0.152.
 */
package org.simantics;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.simantics.PlatformException;
import org.simantics.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseBaselines {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseBaselines.class);
    private static final boolean REQUIRE_INDEX_IN_BASELINE = false;
    private static final String DB_DIRECTORY = "db";
    private static final String INDEX_DIRECTORY = ".metadata/.plugins/org.simantics.db.indexing";
    private static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("d. MMM yyyy HH:mm:ss");

    public static Path packageBaseline(Path fromWorkspace, Path packageFile) throws IOException {
        return DatabaseBaselines.compressZip(fromWorkspace, DatabaseBaselines.collectBaselinePaths(fromWorkspace), packageFile);
    }

    private static List<Path> collectBaselinePaths(Path workspace) throws IOException {
        Path dbPath = workspace.resolve(DB_DIRECTORY);
        Path indexPath = workspace.resolve(INDEX_DIRECTORY);
        if (!Files.isDirectory(dbPath, new LinkOption[0])) {
            throw new IllegalArgumentException("workspace database directory " + dbPath + " does not exist");
        }
        List<Path> paths = Files.walk(dbPath, new FileVisitOption[0]).collect(Collectors.toList());
        if (Files.isDirectory(indexPath, new LinkOption[0])) {
            List indexPaths = Files.walk(indexPath, new FileVisitOption[0]).collect(Collectors.toList());
            paths.addAll(indexPaths);
        }
        return paths;
    }

    /*
     * Unable to fully structure code
     */
    private static Path compressZip(Path relativeRoot, List<Path> paths, Path zipFile) throws IOException {
        if (DatabaseBaselines.LOGGER.isDebugEnabled()) {
            DatabaseBaselines.LOGGER.debug("Compressing " + paths.size() + " path entries into ZIP file " + zipFile);
        }
        try {
            var3_3 = null;
            var4_5 = null;
            try {
                zout = new ZipOutputStream(Files.newOutputStream(zipFile, new OpenOption[0]));
                try {
                    DatabaseBaselines.compressZip(relativeRoot, zout, paths);
                    var7_8 = zipFile;
                    ** try [egrp 3[TRYBLOCK] [1 : 91->143)] { 
                }
lbl15:
                // 1 sources

                catch (Throwable var3_4) {
                    throw var3_4;
                }
                finally {
                    if (zout != null) {
                        zout.close();
                    }
                }
lbl-1000:
                // 1 sources

                {
                    if (DatabaseBaselines.LOGGER.isDebugEnabled()) {
                        DatabaseBaselines.LOGGER.debug("Compressed " + paths.size() + " entries into " + zipFile);
                    }
                    return var7_8;
                }
            }
            catch (Throwable var4_6) {
                if (var3_3 == null) {
                    var3_3 = var4_6;
                } else if (var3_3 != var4_6) {
                    var3_3.addSuppressed(var4_6);
                }
                throw var3_3;
            }
        }
        catch (Throwable var6_9) {
            if (DatabaseBaselines.LOGGER.isDebugEnabled()) {
                DatabaseBaselines.LOGGER.debug("Compressed " + paths.size() + " entries into " + zipFile);
            }
            throw var6_9;
        }
    }

    private static void compressZip(Path relativeRoot, ZipOutputStream zout, List<Path> paths) throws IOException {
        for (Path p : paths) {
            Path rp = relativeRoot.relativize(p);
            String name = rp.toString();
            if (Files.isDirectory(p, new LinkOption[0])) {
                name = name.endsWith("/") ? name : String.valueOf(name) + "/";
                zout.putNextEntry(new ZipEntry(name));
                continue;
            }
            zout.putNextEntry(new ZipEntry(name));
            FileUtils.copy((File)p.toFile(), (OutputStream)zout);
            zout.closeEntry();
        }
    }

    public static byte[] baselineIndicatorContents(Path path) throws IOException {
        return String.format("%s%n%s%n", path.toString(), Instant.now().atZone(ZoneId.systemDefault()).format(TIMESTAMP_FORMAT)).getBytes("UTF-8");
    }

    public static void validateWorkspaceForBaselineInitialization(Path workspaceLocation) throws PlatformException {
        try {
            Path db = workspaceLocation.resolve(DB_DIRECTORY);
            if (Files.exists(db, new LinkOption[0])) {
                throw new PlatformException("Database location " + db + " already exists. Cannot re-initialize workspace from baseline.");
            }
        }
        catch (IOException e) {
            throw new PlatformException("Failed to validate workspace for baseline initialization", e);
        }
    }

    private static boolean isEmptyDirectory(Path dir) throws IOException {
        return Files.walk(dir, new FileVisitOption[0]).count() == 1L;
    }

    public static void validateBaselineFile(Path baseline) throws PlatformException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ZipFile zip = new ZipFile(baseline.toFile());){
                ZipEntry db = zip.getEntry(DB_DIRECTORY);
                if (db == null) {
                    throw new PlatformException("Baseline archive does not contain database directory 'db'");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new PlatformException("Failed to validate baseline archive " + baseline, e);
        }
    }

    public static void initializeWorkspaceWithBaseline(Path baseline, Path workspaceLocation, Path indicatorPath) throws PlatformException {
        try {
            Files.createDirectories(workspaceLocation, new FileAttribute[0]);
            FileUtils.extractZip((File)baseline.toFile(), (File)workspaceLocation.toFile());
            if (indicatorPath != null) {
                Files.write(indicatorPath, DatabaseBaselines.baselineIndicatorContents(indicatorPath), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new PlatformException(e);
        }
    }

    public static void main(String[] args) throws IOException {
        DatabaseBaselines.packageBaseline(Paths.get("D:/temp/desktop/workspace", new String[0]), Paths.get("d:/temp/desktop/workspace/baseline.zip", new String[0]));
    }
}

