/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.server.request;

import java.util.List;
import java.util.Map;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.PossibleTypedParent;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.scl.AbstractExpressionCompilationContext;
import org.simantics.db.layer0.scl.AbstractExpressionCompilationRequest;
import org.simantics.db.layer0.util.RuntimeEnvironmentRequest2;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.document.base.ontology.DocumentationResource;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.specification.EnvironmentSpecification;
import org.simantics.scl.compiler.runtime.RuntimeEnvironment;
import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.structural2.scl.ComponentTypeProperty;
import org.simantics.structural2.scl.FindPossibleComponentTypeRequest;
import org.simantics.structural2.scl.ReadComponentTypeInterfaceRequest;
import org.simantics.utils.datastructures.Pair;

public class ServerSCLHandlerValueRequest
extends AbstractExpressionCompilationRequest<CompilationContext, Object> {
    private final Pair<Resource, Resource> componentTypeAndRoot;
    private final Resource literal;
    protected String possibleExpectedValueType;

    private ServerSCLHandlerValueRequest(Pair<Resource, Resource> componentTypeAndRoot, Resource literal, String possibleExpectedValueType) {
        assert (literal != null);
        this.literal = literal;
        this.componentTypeAndRoot = componentTypeAndRoot;
        this.possibleExpectedValueType = possibleExpectedValueType;
    }

    public ServerSCLHandlerValueRequest(ReadGraph graph, org.simantics.db.layer0.variable.Variable context) throws DatabaseException {
        this(ServerSCLHandlerValueRequest.getComponentTypeAndRoot(graph, context), context.getRepresents(graph), ServerSCLHandlerValueRequest.resolveExpectedValueType((ReadGraph)graph, (Resource)context.getPredicateResource(graph)));
    }

    public ServerSCLHandlerValueRequest(ReadGraph graph, Resource s, Resource o, Resource p) throws DatabaseException {
        this(ServerSCLHandlerValueRequest.getComponentTypeAndRoot(graph, s), o, ServerSCLHandlerValueRequest.resolveExpectedValueType((ReadGraph)graph, (Resource)p));
    }

    private static Pair<Resource, Resource> getComponentTypeAndRoot(ReadGraph graph, org.simantics.db.layer0.variable.Variable property) throws DatabaseException {
        Resource type;
        org.simantics.db.layer0.variable.Variable parent = property.getParent(graph);
        Resource represents = parent.getRepresents(graph);
        if (represents != null && (type = (Resource)graph.syncRequest((Read)new FindPossibleComponentTypeRequest(represents))) != null) {
            Resource root = (Resource)graph.syncRequest((Read)new IndexRoot(type));
            return Pair.make((Object)type, (Object)root);
        }
        parent = parent.getParent(graph);
        Resource root = (Resource)graph.syncRequest((Read)new IndexRoot(property.getRepresents(graph)));
        return Pair.make((Object)parent.getType(graph), (Object)root);
    }

    private static Pair<Resource, Resource> getComponentTypeAndRoot(ReadGraph graph, Resource component) throws DatabaseException {
        if (component != null) {
            Resource type = (Resource)graph.syncRequest((Read)new FindPossibleComponentTypeRequest(component));
            if (type != null) {
                Resource root = (Resource)graph.syncRequest((Read)new IndexRoot(type));
                return Pair.make((Object)type, (Object)root);
            }
            Resource doc = (Resource)graph.syncRequest((Read)new PossibleTypedParent(component, DocumentationResource.getInstance((ReadGraph)graph).Document));
            Resource componentType = graph.getSingleType(doc);
            Resource root = (Resource)graph.syncRequest((Read)new IndexRoot(doc));
            return Pair.make((Object)componentType, (Object)root);
        }
        throw new IllegalStateException();
    }

    public static List<TCon> getEffects(ReadGraph graph, org.simantics.db.layer0.variable.Variable context) throws DatabaseException {
        try {
            ServerSCLHandlerValueRequest req = new ServerSCLHandlerValueRequest(graph, context);
            return req.getExpressionEffects(graph);
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new DatabaseException(t);
        }
    }

    public static Object compileAndEvaluate(ReadGraph graph, org.simantics.db.layer0.variable.Variable context) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.get((Object)"graph");
        try {
            Function1 exp = (Function1)graph.syncRequest((Read)new ServerSCLHandlerValueRequest(graph, context), (Listener)TransientCacheListener.instance());
            sclContext.put((Object)"graph", (Object)graph);
            Object object = exp.apply((Object)context);
            return object;
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new DatabaseException(t);
        }
        finally {
            sclContext.put((Object)"graph", oldGraph);
        }
    }

    public static Function1<Object, Object> compile(ReadGraph graph, org.simantics.db.layer0.variable.Variable context) throws DatabaseException {
        return (Function1)graph.syncRequest((Read)new ServerSCLHandlerValueRequest(graph, context), (Listener)TransientCacheListener.instance());
    }

    public static Function1<Object, Object> compile(ReadGraph graph, Resource s, Resource o, Resource p) throws DatabaseException {
        return (Function1)graph.syncRequest((Read)new ServerSCLHandlerValueRequest(graph, s, o, p), (Listener)TransientCacheListener.instance());
    }

    protected String getExpressionText(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String exp = (String)graph.getRelatedValue(this.literal, L0.SCLValue_expression, (Binding)Bindings.STRING);
        return "\\context -> " + exp;
    }

    protected RuntimeEnvironmentRequest2 getRuntimeEnvironmentRequest(Resource componentType, Resource indexRoot) {
        return new RuntimeEnvironmentRequest2(componentType, indexRoot){

            protected void fillEnvironmentSpecification(EnvironmentSpecification environmentSpecification) {
            }
        };
    }

    protected CompilationContext getCompilationContext(ReadGraph graph) throws DatabaseException {
        return (CompilationContext)((Object)graph.syncRequest((Read)new UnaryRead<Pair<Resource, Resource>, CompilationContext>(this.componentTypeAndRoot){

            public CompilationContext perform(ReadGraph graph) throws DatabaseException {
                RuntimeEnvironment runtimeEnvironment = (RuntimeEnvironment)graph.syncRequest((Read)ServerSCLHandlerValueRequest.this.getRuntimeEnvironmentRequest((Resource)((Pair)this.parameter).first, (Resource)((Pair)this.parameter).second));
                Map propertyMap = (Map)graph.syncRequest((Read)new ReadComponentTypeInterfaceRequest((Resource)((Pair)this.parameter).first, runtimeEnvironment.getEnvironment()), (Listener)TransientCacheListener.instance());
                return new CompilationContext(runtimeEnvironment, propertyMap);
            }
        }));
    }

    protected Type getContextVariableType() {
        return VARIABLE;
    }

    private static Expression accessInputVariable(Environment environment, Variable contextVariable) {
        SCLValue variableParentFunction = environment.getValue(VARIABLE_PARENT);
        return new EApply((Expression)new EConstant(variableParentFunction), (Expression)new EApply((Expression)new EConstant(variableParentFunction), (Expression)new EVariable(contextVariable)));
    }

    protected static Expression standardGetProperty(Environment environment, Variable contextVariable, String name, Type type) {
        return ServerSCLHandlerValueRequest.getPropertyFlexible((Environment)environment, (Expression)ServerSCLHandlerValueRequest.accessInputVariable(environment, contextVariable), (String)name, (Type)type);
    }

    protected Expression getVariableAccessExpression(ReadGraph graph, CompilationContext context, Variable contextVariable, String name) throws DatabaseException {
        ComponentTypeProperty property = context.propertyMap.get(name);
        if (property != null) {
            return ServerSCLHandlerValueRequest.standardGetProperty(context.runtimeEnvironment.getEnvironment(), contextVariable, name, (Type)(property.type == null ? Types.metaVar((Kind)Kinds.STAR) : property.type));
        }
        return this.getSpecialVariableAccessExpression(graph, context, contextVariable, name);
    }

    protected Expression getSpecialVariableAccessExpression(ReadGraph graph, CompilationContext context, Variable contextVariable, String name) throws DatabaseException {
        if (name.equals("input")) {
            Environment environment = context.runtimeEnvironment.getEnvironment();
            return ServerSCLHandlerValueRequest.accessInputVariable(environment, contextVariable);
        }
        if (name.equals("self")) {
            return new EVariable(contextVariable);
        }
        return null;
    }

    protected Type getExpectedType(ReadGraph graph, CompilationContext context) throws DatabaseException {
        return super.getExpectedType(graph, (AbstractExpressionCompilationContext)context);
    }

    public int hashCode() {
        return 31 * (31 * ((Object)((Object)this)).getClass().hashCode() + this.literal.hashCode()) + this.componentTypeAndRoot.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ServerSCLHandlerValueRequest other = (ServerSCLHandlerValueRequest)((Object)obj);
        return this.literal.equals(other.literal) && this.componentTypeAndRoot.equals(other.componentTypeAndRoot);
    }

    public static class CompilationContext
    extends AbstractExpressionCompilationContext {
        public final Map<String, ComponentTypeProperty> propertyMap;

        public CompilationContext(RuntimeEnvironment runtimeEnvironment, Map<String, ComponentTypeProperty> propertyMap) {
            super(runtimeEnvironment);
            this.propertyMap = propertyMap;
        }
    }
}

