/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.structural.ui.modelBrowser;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.browsing.ui.platform.GraphExplorerView;
import org.simantics.browsing.ui.swt.ViewArgumentUtils;
import org.simantics.db.RequestProcessor;
import org.simantics.db.UndoContext;
import org.simantics.db.common.UndoContextEx;
import org.simantics.db.exception.DatabaseException;
import org.simantics.structural.ui.Activator;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class ModelBrowser
extends GraphExplorerView {
    private static final String CONTEXT_MENU_ID = "#GraphExplorerPopup";
    private static final Set<String> uiContexts = Collections.singleton("org.simantics.modeling.ui.modelBrowser");
    private static final Set<String> defaultBrowseContexts = Collections.singleton("http://www.simantics.org/Structural-0.0/ModelBrowser");
    protected UndoContext undoContext = new UndoContextEx("ModelBrowser");

    protected Set<String> getUiContexts() {
        return uiContexts;
    }

    protected Set<String> getBrowseContexts() {
        return defaultBrowseContexts;
    }

    protected String getContextMenuId() {
        return CONTEXT_MENU_ID;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == UndoContext.class) {
            return this.undoContext;
        }
        return super.getAdapter(adapter);
    }

    protected void createControls(Composite parent) {
        Activator.initializeResourceManager(parent.getDisplay());
        super.createControls(parent);
    }

    protected static Set<String> loadBrowseContexts(Set<String> browseContexts) {
        try {
            return BrowseContext.getBrowseContextClosure((RequestProcessor)Simantics.getSession(), browseContexts);
        }
        catch (DatabaseException e) {
            ExceptionUtils.logAndShowError((String)"Failed to load modeled browse contexts for property page, see exception for details.", (Throwable)e);
            return browseContexts;
        }
    }

    class HomeAction
    extends Action {
        public HomeAction() {
            super("Home", 1);
            this.setToolTipText("Navigate to root library");
            this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_HOME_NAV"));
            this.setDisabledImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_HOME_NAV_DISABLED"));
        }

        public void run() {
            HashMap<String, String> args = new HashMap<String, String>();
            args.put("view", ModelBrowser.this.getSite().getId());
            String argString = ViewArgumentUtils.encodeArguments(args);
            try {
                WorkbenchUtils.showView((String)("org.simantics.browsing.ui.graph.browseDebugger:" + argString));
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
        }
    }
}

