/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph.adapter;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.ConstantChildVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.spreadsheet.Range;
import org.simantics.spreadsheet.common.cell.VariableCellEditor;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.spreadsheet.util.SpreadsheetUtils;

public class DoubleArrayCellVariable
extends ConstantChildVariable {
    public DoubleArrayCellVariable(Variable parent, String name, String[] properties, Binding[] bindings, Object ... values) {
        super(parent, name, properties, bindings, values);
    }

    protected <T> T tryAdapt(ReadGraph graph, Class<T> clazz) throws DatabaseException {
        if (VariableCellEditor.class == clazz) {
            return (T)new VariableCellEditor(){

                public void edit(WriteGraph graph, Variable cell, String text) throws DatabaseException {
                    SpreadsheetResource sr = SpreadsheetResource.getInstance((ReadGraph)graph);
                    Resource configuration = cell.getPossibleRepresents((ReadGraph)graph);
                    double[] data = (double[])graph.getPossibleRelatedValue(configuration, sr.DoubleArrayCell_HasDoubleArray, (Binding)Bindings.DOUBLE_ARRAY);
                    if (data == null) {
                        return;
                    }
                    Integer width = (Integer)graph.getPossibleRelatedValue(configuration, sr.DoubleArrayCell_HasWidth, (Binding)Bindings.INTEGER);
                    if (width == null) {
                        return;
                    }
                    String baseLocation = (String)graph.getPossibleRelatedValue(configuration, sr.HasLocation, (Binding)Bindings.STRING);
                    if (baseLocation == null) {
                        return;
                    }
                    String editLocation = (String)cell.getPossiblePropertyValue((ReadGraph)graph, "HasName");
                    Range baseRange = SpreadsheetUtils.decodeCellAbsolute((String)baseLocation);
                    Range editRange = SpreadsheetUtils.decodeCellAbsolute((String)editLocation);
                    int x = editRange.startColumn - baseRange.startColumn;
                    int y = editRange.startRow - baseRange.startRow;
                    int height = data.length / width;
                    if (x >= 0 && x < width && y >= 0 && y < height) {
                        data[width.intValue() * y + x] = Double.parseDouble(text);
                    }
                    graph.claimLiteral(configuration, sr.DoubleArrayCell_HasDoubleArray, (Object)data, (Binding)Bindings.DOUBLE_ARRAY);
                }

                public void copy(WriteGraph graph, Variable cell, String location) throws DatabaseException {
                }
            };
        }
        return null;
    }

    public <T> T adapt(ReadGraph graph, Class<T> clazz) throws DatabaseException {
        T t = this.tryAdapt(graph, clazz);
        return (T)(t != null ? t : super.adapt(graph, clazz));
    }

    public <T> T adaptPossible(ReadGraph graph, Class<T> clazz) throws DatabaseException {
        return this.tryAdapt(graph, clazz);
    }
}

