/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.graphfile;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.request.WriteResult;
import org.simantics.document.DocumentResource;
import org.simantics.graphfile.ontology.GraphFileResource;
import org.simantics.graphfile.util.GraphFileUtil;
import org.simantics.layer0.Layer0;
import org.simantics.utils.ui.ExceptionUtils;

public class FileDocumentUtil {
    private static final char ESCAPE = '%';

    public static Resource importFile(final String fileName, final Resource lib, final Resource rel) throws DatabaseException {
        return (Resource)Simantics.getSession().syncRequest((WriteResult)new WriteResultRequest<Resource>(){

            public Resource perform(WriteGraph graph) throws DatabaseException {
                return FileDocumentUtil.importFile(graph, fileName, lib, rel);
            }
        });
    }

    public static void importFileAsync(final String fileName, final Resource lib, final Resource rel) {
        Simantics.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                FileDocumentUtil.importFile(graph, fileName, lib, rel);
            }
        }, e -> {
            if (e != null) {
                ExceptionUtils.logAndShowError((String)("Cannot import file " + fileName), (Throwable)e);
            }
        });
    }

    public static Resource importFile(WriteGraph graph, String fileName, Resource lib, Resource rel) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource fileResource = FileDocumentUtil.importFile(graph, fileName);
        graph.claim(lib, rel, fileResource);
        File file = new File(fileName);
        String name = file.getName();
        graph.claimLiteral(fileResource, l0.HasName, (Object)name);
        FileDocumentUtil.setUniqueName(graph, fileResource, lib, rel);
        return fileResource;
    }

    public static Resource importFileWithName(WriteGraph graph, String fileName) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource fileResource = FileDocumentUtil.importFile(graph, fileName);
        File file = new File(fileName);
        String name = file.getName();
        graph.claimLiteral(fileResource, l0.HasName, (Object)name);
        return fileResource;
    }

    public static Resource importFolderWithName(WriteGraph graph, String folderName, Resource lib, Resource folderType, Resource relation, IProgressMonitor monitor) throws Exception {
        Resource folderRes = FileDocumentUtil.importFolderWithName(graph, folderName, folderType, relation, monitor);
        graph.claim(lib, relation, folderRes);
        FileDocumentUtil.createUniqueName(graph, folderRes);
        return folderRes;
    }

    public static Resource importFolderWithName(WriteGraph graph, String folderName, Resource folderType, Resource relation, IProgressMonitor monitor) throws Exception {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        File folder = new File(folderName);
        Resource rootFolderRes = graph.newResource();
        graph.claim(rootFolderRes, l0.InstanceOf, folderType);
        graph.claimLiteral(rootFolderRes, l0.HasName, (Object)folder.getName());
        FileDocumentUtil.importFolder(graph, folder, rootFolderRes, relation, monitor);
        return rootFolderRes;
    }

    public static void importFolder(WriteGraph graph, File folder, Resource folderResource, Resource relation, IProgressMonitor monitor) throws Exception {
        if (monitor != null) {
            int count = FileDocumentUtil._countFiles(folder);
            monitor.beginTask("Import files", count);
        }
        FileDocumentUtil._importFolder(graph, folder, folderResource, relation, monitor);
        if (monitor != null) {
            monitor.done();
        }
    }

    private static void _importFolder(WriteGraph graph, File folder, Resource folderResource, Resource relation, IProgressMonitor monitor) throws Exception {
        File[] files;
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        File[] fileArray = files = folder.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                Resource newFolderRes = graph.newResource();
                graph.claim(newFolderRes, l0.InstanceOf, graph.getSingleType(folderResource));
                graph.claim(folderResource, relation, newFolderRes);
                graph.claimLiteral(newFolderRes, l0.HasName, (Object)f.getName());
                FileDocumentUtil._importFolder(graph, f, newFolderRes, relation, monitor);
            } else {
                Resource fileRes = null;
                if (!FileDocumentUtil.isUrl(f)) {
                    fileRes = FileDocumentUtil.importURL(graph, f);
                    fileRes = FileDocumentUtil.importFileWithName(graph, f.getAbsolutePath());
                }
                graph.claim(folderResource, relation, fileRes);
                if (monitor != null) {
                    monitor.worked(1);
                }
            }
            ++n2;
        }
    }

    private static int _countFiles(File folder) {
        File[] files;
        int count = 0;
        File[] fileArray = files = folder.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            count = f.isDirectory() ? (count += FileDocumentUtil._countFiles(f)) : ++count;
            ++n2;
        }
        return count;
    }

    public static void createUniqueName(WriteGraph graph, Resource document) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        Resource lib = graph.getPossibleObject(document, l0.PartOf);
        if (lib == null) {
            return;
        }
        FileDocumentUtil.setUniqueName(graph, document, lib, l0.ConsistsOf);
    }

    public static void setUniqueName(WriteGraph graph, Resource res, Resource lib, Resource rel) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        HashSet<String> names = new HashSet<String>();
        for (Resource r : graph.getObjects(lib, rel)) {
            if (r.equals(res)) continue;
            names.add((String)graph.getRelatedValue(r, l0.HasName));
        }
        String name = (String)graph.getRelatedValue(res, l0.HasName);
        if (!names.contains(name)) {
            return;
        }
        int i = 1;
        while (true) {
            String proposal;
            if (!names.contains(proposal = String.valueOf(name) + " (" + i + ")")) {
                graph.claimLiteral(res, l0.HasName, (Object)proposal);
                return;
            }
            ++i;
        }
    }

    public static Resource importFile(WriteGraph graph, String fileName) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        DocumentResource doc = DocumentResource.getInstance((ReadGraph)graph);
        Resource fileResource = graph.newResource();
        graph.claim(fileResource, l0.InstanceOf, doc.FileDocument);
        try {
            GraphFileUtil.toGraph((WriteGraph)graph, (String)fileName, (Resource)fileResource);
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
        return fileResource;
    }

    public static void exportDocumentFolder(final Resource folderResource, final File folder, final Resource relation, final boolean useResourceNames, final IProgressMonitor monitor) throws Exception {
        Simantics.getSession().syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                try {
                    FileDocumentUtil.exportDocumentFolder(graph, folderResource, folder, relation, useResourceNames, monitor);
                }
                catch (Exception e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
        });
    }

    public static void exportDocumentFolder(ReadGraph graph, Resource folderResource, File folder, Resource relation, boolean useResourceNames, IProgressMonitor monitor) throws Exception {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        DocumentResource doc = DocumentResource.getInstance((ReadGraph)graph);
        GraphFileResource gf = GraphFileResource.getInstance((ReadGraph)graph);
        HashSet<String> names = new HashSet<String>();
        Collection folderType = graph.getPrincipalTypes(folderResource);
        for (Resource r : graph.getObjects(folderResource, relation)) {
            if (graph.isInstanceOf(r, doc.Document)) {
                String name = null;
                boolean canExport = false;
                if (graph.isInstanceOf(r, doc.FileDocument)) {
                    name = (String)graph.getRelatedValue(r, useResourceNames ? gf.HasResourceName : l0.HasName);
                    canExport = true;
                } else if (graph.isInstanceOf(r, doc.UrlDocument)) {
                    name = graph.getRelatedValue(r, l0.HasName) + ".url";
                    canExport = true;
                }
                if (!canExport) continue;
                name = FileDocumentUtil.resolveName(folder, name, names, true);
                File file = new File(String.valueOf(folder.getAbsolutePath()) + "/" + name);
                if (graph.isInstanceOf(r, doc.FileDocument)) {
                    GraphFileUtil.writeDataToFile((ReadGraph)graph, (Resource)r, (File)file);
                } else if (graph.isInstanceOf(r, doc.UrlDocument)) {
                    String url = (String)graph.getRelatedValue(r, doc.HasUrl);
                    String n = (String)graph.getRelatedValue(r, l0.HasName);
                    FileDocumentUtil.exportUrl(file, n, url);
                }
                if (monitor == null) continue;
                monitor.worked(1);
                continue;
            }
            Collection type = graph.getPrincipalTypes(r);
            if (type.size() != folderType.size() || !folderType.containsAll(type)) continue;
            String name = (String)graph.getRelatedValue(r, l0.HasName);
            name = FileDocumentUtil.resolveName(folder, name, names, false);
            File subFolder = new File(String.valueOf(folder.getAbsolutePath()) + "/" + name);
            if (!subFolder.exists() && !subFolder.mkdir()) continue;
            FileDocumentUtil.exportDocumentFolder(graph, r, subFolder, relation, useResourceNames, monitor);
        }
    }

    private static void exportUrl(File toFile, String name, String url) throws Exception {
        PrintStream os = new PrintStream(toFile, "UTF-8");
        os.println("[InternetShortcut]");
        os.println("URL=" + url);
        os.println("name=" + name);
        os.flush();
        os.close();
    }

    public static Resource importURL(WriteGraph graph, File file) throws Exception {
        String s = null;
        String url = null;
        String name = null;
        try (BufferedReader is = null;){
            is = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            while ((s = is.readLine()) != null) {
                if (s.startsWith("URL=")) {
                    url = s.substring(4);
                    continue;
                }
                if (!s.startsWith("name=")) continue;
                name = s.substring(5);
            }
        }
        if (url == null) {
            return null;
        }
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        DocumentResource doc = DocumentResource.getInstance((ReadGraph)graph);
        Resource fileResource = graph.newResource();
        graph.claim(fileResource, l0.InstanceOf, doc.UrlDocument);
        if (name == null) {
            name = file.getName();
            name = FileDocumentUtil.unescape(name);
            name = name.substring(0, name.length() - 4);
        }
        graph.claimLiteral(fileResource, l0.HasName, (Object)name);
        graph.claimLiteral(fileResource, doc.HasUrl, (Object)url);
        return fileResource;
    }

    private static boolean isUrl(File file) throws Exception {
        return file.getAbsolutePath().endsWith(".url");
    }

    private static String escape(String s) {
        int len = s.length();
        StringBuilder sb = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            if (ch < ' ' || ch >= '\u007f' || ch == '/' || ch == '\\' || ch == ':' || ch == '%') {
                sb.append('%');
                if (ch < '\u0010') {
                    sb.append('0');
                }
                sb.append(Integer.toHexString(ch));
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    private static String unescape(String s) {
        int len = s.length();
        StringBuilder sb = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            if (ch == '%') {
                String num = "0x";
                num = String.valueOf(num) + s.charAt(++i);
                num = String.valueOf(num) + s.charAt(++i);
                ch = (char)Integer.decode(num).intValue();
            }
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }

    private static String resolveName(File parentFolder, String proposal, Set<String> used, boolean file) {
        String current = FileDocumentUtil.escape(proposal);
        int i = 0;
        if (file) {
            while (true) {
                ++i;
                if (used.contains(current)) {
                    current = FileDocumentUtil.createFileName(proposal, i);
                    continue;
                }
                File subFile = new File(String.valueOf(parentFolder.getAbsolutePath()) + "/" + current);
                if (!subFile.exists() || subFile.exists() && subFile.isFile() && subFile.canWrite()) break;
            }
        } else {
            while (true) {
                ++i;
                if (used.contains(current)) {
                    current = String.valueOf(proposal) + i;
                    continue;
                }
                File subFolder = new File(String.valueOf(parentFolder.getAbsolutePath()) + "/" + current);
                if (!subFolder.exists() || subFolder.exists() && subFolder.isDirectory()) break;
            }
        }
        used.add(current);
        return current;
    }

    private static String createFileName(String original, int i) {
        int extIndex = original.lastIndexOf(".");
        if (extIndex == -1) {
            return String.valueOf(original) + i;
        }
        return String.valueOf(original.substring(0, extIndex)) + i + original.substring(extIndex);
    }
}

