/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.contribution;

import java.util.Collection;
import org.eclipse.jface.dialogs.IInputValidator;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.utils.ui.AdaptionUtils;

public class NameInputValidator
implements IInputValidator,
Widget {
    private Resource selection;

    public String isValid(final String newText) {
        if (newText == null || newText.length() == 0) {
            return "Empty name is not allowed";
        }
        if (this.selection != null) {
            try {
                return (String)Simantics.getSession().syncRequest((Read)new Read<String>(){

                    public String perform(ReadGraph graph) throws DatabaseException {
                        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                        Resource lib = graph.getPossibleObject(NameInputValidator.this.selection, l0.PartOf);
                        if (lib == null) {
                            return null;
                        }
                        Collection resources = graph.getObjects(lib, l0.ConsistsOf);
                        for (Resource resource : resources) {
                            String n;
                            if (resource.equals(NameInputValidator.this.selection) || !newText.equals(n = (String)graph.getPossibleRelatedValue(resource, l0.HasName))) continue;
                            return "Cannot have duplicate name " + newText;
                        }
                        return null;
                    }
                });
            }
            catch (DatabaseException e) {
                return e.getMessage();
            }
        }
        return null;
    }

    public void setInput(ISessionContext context, Object input) {
        this.selection = (Resource)AdaptionUtils.adaptToSingle((Object)input, Resource.class);
    }
}

