# DB module documentation

::data[Resource]

## Reading

### URIs

::value[resource, possibleResource, relativeResource]

### Graph hierarchy

::class[Browsable]

### Objects

::value[#, singleObject, possibleObject]
::value[objectsWithType]

### Statements

::data[Statement]
::value[subjectOf, predicateOf, objectOf]
::value[statements, singleStatement]

### Special objects

::value[singleTypeOf, possibleTypeOf]
::value[inverseOf]

### Literals

::value[relatedValue, possibleRelatedValue]
::value[relatedValue2]
::value[untypedValueOf, untypedRelatedValue, untypedPossibleRelatedValue]

### Predicates

::value[isInstanceOf, isSubrelationOf, isInheritedFrom, isParent]
::value[existsStatement, existsStatement3]

### Special resources

::value[currentModel, currentProject, getRootLibrary, listOntologies]

### Resource id

::value[resourceId, resourceFromId]

## Writing

### Adding statements

::value[newResource]
::value[claim]
::value[deny, denyByPredicate, denyAllStatements]
::value[claimAssertion]

### Writing literals

::value[claimRelatedValue, claimRelatedValueWithType]
::value[untypedClaimRelatedValue]
::value[denyValue]

## Ordered sets

::value[addToOrderedSet]
::value[setOrderedSet]
::value[elementsOfOrderedSet]
::value[parentOrderedSet]

## Transactions

::value[syncRead, asyncRead]
::value[syncWrite, asyncWrite]
::value[virtualSyncWriteMem, virtualSyncWriteWS] 
::value[lift1Read, lift2Read, lift3Read]
::value[lift1Write, lift2Write, lift3Write]
::value[addCommentMetadata]
::value[makeSynchronous]
::value[enableDependencies, disableDependencies]

## Undo

::value[markUndoPoint, startUndoPoint]
::value[undo, redo, undoOperations]

## Generation of resource names

::value[findFreshName, findFreshEscapedName]

## Helper functions for handling URIs

::value[escapeURI, unescapeURI, splitURI]

## Structured graph writing

::value[newEntity]
::value[hasStatement, hasName, hasType, hasLabel, hasProperty, hasTypedProperty, hasPossibleProperty, hasParent]

## Clusters

::value[newClusterSet, selectClusterSet, sortByCluster]

## Debugging

::value[queryDebugSupport, queryListSupport]

## Miscellaneous functions

::undocumented[]