package org.simantics.scl.compiler.parsing.documentation;

%%

%public
%char
%unicode
%class DocumentationLexer
%function nextToken
%type DocumentationElement
%yylexthrow DocumentationParsingException
%eofval{
    return null;
%eofval}

%{
    public static String trimW(String text) {
        int a = 0, b = text.length();
        while(a < b) {
            char c = text.charAt(a);
            if(c != ' ' && c != '\t' && c != '\r' && c != '\n')
                break;
            ++a;
        }
        while(a < b) {
            char c = text.charAt(b-1);
            if(c != ' ' && c != '\t' && c != '\r' && c != '\n')
                break;
            --b;
        }
        return text.substring(a, b);
    }

    public static String trimN(String text, int amount) {        
        text = trimW(text);
        return text.substring(amount, text.length()-amount).trim();
    }
%}

whitespace      = [ \t]
eol             = "\n" | "\r\n"
textStartChar   = [^ \n\r*>=-]
textLine        = {whitespace}* {textStartChar} [^\n\r]* {eol}
emptyLine       = {eol}
h1              = "=" [^\n\r=][^\n\r]*[^\n\r=] "=" {whitespace}* {eol}
h2              = "==" [^\n\r=][^\n\r]*[^\n\r=] "==" {whitespace}* {eol}
h3              = "===" [^\n\r=][^\n\r]*[^\n\r=] "===" {whitespace}* {eol}
h3              = "===" [^\n\r=][^\n\r]*[^\n\r=] "===" {whitespace}* {eol}
listItem        = [*#]+ [^\n\r]* {eol}
birdTrack       = ">" [^\n\r]* {eol}
entityRef       = "-" [^\n\r]* {eol}
%%

<YYINITIAL> {
    {textLine}+   { return new Paragraph(yytext().trim()); }
    {birdTrack}+  { return new Preformatted(yytext()); }
    {h1}          { return new Header(1, trimN(yytext(), 1)); }
    {h2}          { return new Header(2, trimN(yytext(), 2)); }
    {h3}          { return new Header(3, trimN(yytext(), 3)); }
    {listItem}    { return new ListItem(trimW(yytext())); }
    {entityRef}   { return new EntityRef(trimW(yytext().substring(1))); }
    {emptyLine}   { }    
    {whitespace}+ { }
     .            { System.err.println("At " + yychar + ": Illegal character '" + yytext() + "'."); }
}
