/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.common;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.common.node.StandardNodes;

public final class Testers {
    public static final Tester PASS = new Tester(){

        public boolean test(NodeQueryManager manager, NodeContext context) {
            return true;
        }

        public String toString() {
            return "PASS test";
        }
    };
    public static final Tester FAIL = new Tester(){

        public boolean test(NodeQueryManager manager, NodeContext context) {
            return false;
        }

        public String toString() {
            return "FAIL test";
        }
    };

    public static Tester instanceOfTester(final Class<?> clazz) {
        return new Tester(){

            public boolean test(NodeQueryManager manager, NodeContext context) {
                return clazz.isInstance(context.getConstant(BuiltinKeys.INPUT));
            }

            public String toString() {
                return "class " + clazz.getName() + " test";
            }
        };
    }

    public static Tester standardFunctionTester(final Object object) {
        return new Tester(){

            public boolean test(NodeQueryManager manager, NodeContext context) {
                Object function = context.getConstant(StandardNodes.FUNCTION);
                return object.equals(function);
            }
        };
    }

    public static <T> Tester exists(final NodeContext.ConstantKey<T> key) {
        return new Tester(){

            public boolean test(NodeQueryManager manager, NodeContext context) {
                return context.getConstant(key) != null;
            }
        };
    }

    public static Tester and(final Tester ... testers) {
        return new Tester(){

            public boolean test(NodeQueryManager manager, NodeContext context) {
                Tester[] testerArray = testers;
                int n = testers.length;
                int n2 = 0;
                while (n2 < n) {
                    Tester tester = testerArray[n2];
                    if (!tester.test(manager, context)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        };
    }
}

