/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.utils.ui.jface;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;

public class StringListLabelProvider
implements ITableLabelProvider,
ILabelProvider {
    private final List<String[]> data;
    private List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();

    public StringListLabelProvider(String[][] lines) {
        this.data = new ArrayList<String[]>(lines.length);
        String[][] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] line = stringArray[n2];
            this.data.add(line);
            ++n2;
        }
    }

    public List<String[]> getData() {
        return this.data;
    }

    public StringListLabelProvider(List<String[]> data) {
        this.data = data;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String[] line = (String[])element;
        if (line == null) {
            return null;
        }
        if (columnIndex >= line.length) {
            return null;
        }
        return line[columnIndex];
    }

    protected ILabelProviderListener[] getListeners() {
        return this.listeners.toArray(new ILabelProviderListener[0]);
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
        this.listeners.clear();
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        return this.getColumnText(element, 0);
    }

    public void refreshAll() {
        LabelProviderChangedEvent e = new LabelProviderChangedEvent((IBaseLabelProvider)this);
        ILabelProviderListener[] iLabelProviderListenerArray = this.getListeners();
        int n = iLabelProviderListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelProviderListener listener = iLabelProviderListenerArray[n2];
            listener.labelProviderChanged(e);
            ++n2;
        }
    }

    public void elementChanged(Object ... element) {
        LabelProviderChangedEvent e = new LabelProviderChangedEvent((IBaseLabelProvider)this, element);
        ILabelProviderListener[] iLabelProviderListenerArray = this.getListeners();
        int n = iLabelProviderListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILabelProviderListener listener = iLabelProviderListenerArray[n2];
            listener.labelProviderChanged(e);
            ++n2;
        }
    }
}

