/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.issues.common;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.TernaryAsyncRead;
import org.simantics.db.procedure.AsyncMultiProcedure;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.AsyncRead;
import org.simantics.issues.Severity;
import org.simantics.issues.common.MaxIssueSeverityRecursive;

public class ChildMaxIssueSeverity
extends TernaryAsyncRead<Resource, Resource, Set<Resource>, Severity> {
    public ChildMaxIssueSeverity(Resource resource, Resource childRelation, Set<Resource> typesToRecurse) {
        super((Object)resource, (Object)childRelation, typesToRecurse);
    }

    public void perform(AsyncReadGraph graph, final AsyncProcedure<Severity> procedure) {
        graph.forTypes((Resource)this.parameter, (AsyncProcedure)new AsyncProcedure<Set<Resource>>(){

            public void execute(AsyncReadGraph graph, Set<Resource> result) {
                if (!Collections.disjoint((Collection)ChildMaxIssueSeverity.this.parameter3, result)) {
                    ChildMaxIssueSeverity.this.checkChildren(graph, (AsyncProcedure<Severity>)procedure);
                } else {
                    procedure.execute(graph, null);
                }
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                procedure.exception(graph, throwable);
            }
        });
    }

    protected void checkChildren(AsyncReadGraph graph, final AsyncProcedure<Severity> procedure) {
        graph.forEachObject((Resource)this.parameter, (Resource)this.parameter2, (AsyncMultiProcedure)new AsyncMultiProcedure<Resource>(){
            AtomicReference<Severity> maxSeverity = new AtomicReference();

            public void execute(AsyncReadGraph graph, Resource child) {
                graph.asyncRequest((AsyncRead)new MaxIssueSeverityRecursive(child, (Resource)ChildMaxIssueSeverity.this.parameter2, (Set)ChildMaxIssueSeverity.this.parameter3), (AsyncProcedure)new AsyncProcedure<Severity>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void execute(AsyncReadGraph graph, Severity severity) {
                        if (severity != null) {
                            AtomicReference<Severity> atomicReference = maxSeverity;
                            synchronized (atomicReference) {
                                maxSeverity.set(Severity.moreSevere((Severity)maxSeverity.get(), (Severity)severity));
                            }
                        }
                    }

                    public void exception(AsyncReadGraph graph, Throwable throwable) {
                        procedure.exception(graph, throwable);
                    }
                });
            }

            public void finished(AsyncReadGraph graph) {
                procedure.execute(graph, (Object)this.maxSeverity.get());
            }

            public void exception(AsyncReadGraph graph, Throwable throwable) {
                procedure.exception(graph, throwable);
            }
        });
    }
}

