/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.graphfile;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.document.DocumentResource;
import org.simantics.document.ui.Activator;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.ui.workbench.editor.EditorAdapter;
import org.simantics.utils.ui.ExceptionUtils;

public class UrlEditorAdapter
extends AbstractResourceEditorAdapter
implements EditorAdapter {
    public UrlEditorAdapter() {
        super("Browser", Activator.imageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/world.png"));
    }

    public boolean canHandle(ReadGraph g, Resource r) throws DatabaseException {
        DocumentResource doc = DocumentResource.getInstance((ReadGraph)g);
        if (!g.isInstanceOf(r, doc.UrlDocument)) {
            return false;
        }
        String url = (String)g.getPossibleRelatedValue(r, doc.HasUrl);
        return url != null;
    }

    protected void openEditor(final Resource input) throws Exception {
        Simantics.getSession().asyncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                DocumentResource doc = DocumentResource.getInstance((ReadGraph)graph);
                final String urlString = (String)graph.getPossibleRelatedValue(input, doc.HasUrl);
                if (urlString == null) {
                    return;
                }
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                        try {
                            IWebBrowser browser = browserSupport.createBrowser(null);
                            URL url = new URL(urlString);
                            browser.openURL(url);
                        }
                        catch (PartInitException e1) {
                            ExceptionUtils.logAndShowError((Throwable)e1);
                        }
                        catch (MalformedURLException e2) {
                            ExceptionUtils.logAndShowError((Throwable)e2);
                        }
                    }
                });
            }
        });
    }
}

