/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui.graphfile;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.ui.PartInitException;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.document.DocumentResource;
import org.simantics.document.ui.Activator;
import org.simantics.editors.Editors;
import org.simantics.graphfile.util.GraphFileUtil;
import org.simantics.layer0.Layer0;
import org.simantics.ui.workbench.editor.AbstractResourceEditorAdapter;
import org.simantics.ui.workbench.editor.EditorAdapter;
import org.simantics.utils.ui.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalEditorAdapter
extends AbstractResourceEditorAdapter
implements EditorAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalEditorAdapter.class);
    private static final Map<Path, Resource> tempFiles = new ConcurrentHashMap<Path, Resource>();
    private static ExternalFileWatcher fileWatcher;

    public ExternalEditorAdapter() {
        super("External Editor", Activator.imageDescriptorFromPlugin((String)"com.famfamfam.silk", (String)"icons/page.png"));
    }

    public boolean canHandle(ReadGraph g, Resource r) throws DatabaseException {
        DocumentResource doc = DocumentResource.getInstance((ReadGraph)g);
        return g.isInstanceOf(r, doc.FileDocument);
    }

    protected void openEditor(final Resource input) throws Exception {
        ExternalEditorAdapter.watch();
        Path path = null;
        for (Map.Entry<Path, Resource> entry : tempFiles.entrySet()) {
            Resource value = entry.getValue();
            if (!input.equals(value)) continue;
            path = entry.getKey();
        }
        if (path == null) {
            path = (Path)Simantics.getSession().syncRequest((Read)new UniqueRead<Path>(){

                public Path perform(ReadGraph graph) throws DatabaseException {
                    StringBuilder sb = new StringBuilder();
                    String uri = graph.getPossibleURI(input);
                    if (uri != null) {
                        sb.append(ExternalEditorAdapter.generateSHA1(uri)).append("_");
                    }
                    sb.append(graph.getRelatedValue(input, Layer0.getInstance((ReadGraph)graph).HasName).toString());
                    Path filePath = Activator.getInstanceLocation().resolve(sb.toString());
                    tempFiles.computeIfAbsent(filePath, t -> {
                        try {
                            GraphFileUtil.writeDataToFile((ReadGraph)graph, (Resource)input, (File)filePath.toFile());
                        }
                        catch (IOException | DatabaseException e) {
                            LOGGER.error("Could not write data to file ", e);
                        }
                        return input;
                    });
                    LOGGER.info("Adding tempFile {} with resource {}", (Object)filePath, (Object)input);
                    return filePath;
                }
            });
        }
        try {
            Editors.openExternalEditor((File)path.toFile());
        }
        catch (PartInitException e) {
            ExceptionUtils.logAndShowError((Throwable)e);
        }
    }

    public static String generateSHA1(String message) {
        return ExternalEditorAdapter.hashString(message, "SHA-1");
    }

    private static String hashString(String message, String algorithm) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] hashedBytes = digest.digest(message.getBytes("UTF-8"));
            return ExternalEditorAdapter.convertByteArrayToHexString(hashedBytes);
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException ex) {
            LOGGER.error("Could not generate hash", (Throwable)ex);
            return "";
        }
    }

    private static String convertByteArrayToHexString(byte[] arrayBytes) {
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < arrayBytes.length) {
            stringBuffer.append(Integer.toString((arrayBytes[i] & 0xFF) + 256, 16).substring(1));
            ++i;
        }
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void watch() throws IOException {
        if (fileWatcher != null) return;
        Class<ExternalEditorAdapter> clazz = ExternalEditorAdapter.class;
        synchronized (ExternalEditorAdapter.class) {
            if (fileWatcher != null) return;
            fileWatcher = new ExternalFileWatcher();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static void stopFileWatcher() {
        tempFiles.clear();
        if (fileWatcher != null) {
            fileWatcher.stop();
            fileWatcher = null;
        }
    }

    static class ExternalFileWatcher {
        private ExecutorService service = Executors.newFixedThreadPool(1, r -> {
            Thread t = new Thread(r);
            t.setDaemon(true);
            return t;
        });
        private final WatchService ws;
        private final AtomicBoolean stopped = new AtomicBoolean(true);
        private ConcurrentHashMap<WatchKey, Path> keys = new ConcurrentHashMap();

        public ExternalFileWatcher() throws IOException {
            this.ws = FileSystems.getDefault().newWatchService();
            this.register(Activator.getInstanceLocation());
            this.service.submit(() -> {
                this.stopped.set(false);
                while (!this.stopped.get()) {
                    try {
                        WatchKey key = this.ws.take();
                        for (WatchEvent<?> watchEvent : key.pollEvents()) {
                            if (StandardWatchEventKinds.OVERFLOW == watchEvent.kind()) continue;
                            WatchEvent<?> pathEvent = watchEvent;
                            WatchEvent.Kind<?> kind = pathEvent.kind();
                            Path parent = this.keys.get(key);
                            Path newPath = parent.resolve((Path)pathEvent.context());
                            if (StandardWatchEventKinds.ENTRY_MODIFY == kind) {
                                LOGGER.info("New path modified: " + newPath);
                                Resource resource = (Resource)tempFiles.get(newPath);
                                if (resource != null) {
                                    GraphFileUtil.writeDataToGraph((File)newPath.toFile(), (Resource)resource);
                                    continue;
                                }
                                LOGGER.warn("No resource found for {}", (Object)newPath.toAbsolutePath());
                                continue;
                            }
                            if (StandardWatchEventKinds.ENTRY_DELETE != kind) continue;
                            System.out.println("New path deleted: " + newPath);
                        }
                        if (key.reset()) continue;
                        this.keys.remove(key);
                    }
                    catch (InterruptedException e) {
                        if (this.stopped.get()) continue;
                        LOGGER.error("Could not stop", (Throwable)e);
                    }
                    catch (Throwable t) {
                        LOGGER.error("An error occured", t);
                    }
                }
            });
        }

        public void stop() {
            this.stopped.set(true);
        }

        private void register(Path path) throws IOException {
            if (Files.isDirectory(path, new LinkOption[0])) {
                LOGGER.info("Registering path {}", (Object)path);
                WatchKey key = path.toAbsolutePath().register(this.ws, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                this.keys.put(key, path);
            }
        }
    }
}

