/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.server.environment;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.simantics.db.procore.server.environment.ExecutionEnvironment;
import org.simantics.db.procore.server.environment.ExecutionEnvironmentException;
import org.simantics.db.procore.server.environment.InstallException;
import org.simantics.db.procore.server.environment.RebootRequiredException;
import org.simantics.db.procore.server.environment.windows.Msi;
import org.simantics.db.procore.server.environment.windows.Product;
import org.simantics.db.procore.server.environment.windows.ProductCodes;

public final class ServerEnvironment {
    private static final int ERROR_SUCCESS = 0;
    private static final int ERROR_SUCCESS_REBOOT_REQUIRED = 3010;

    public static void ensureServerDependenciesMet() throws ExecutionEnvironmentException {
        ExecutionEnvironment env = ExecutionEnvironment.calculate();
        block0 : switch (env.os) {
            case WINDOWS: {
                switch (env.arch) {
                    case X86: {
                        Msi.checkOneOfProductsInstalled(ProductCodes.VISUAL_CPP_2008_SP1_REDIST_X86_KB2467174);
                        break block0;
                    }
                    case X86_64: {
                        Msi.checkProductsInstalled(ProductCodes.VISUAL_CPP_2008_SP1_REDIST_X86_KB2467174, ProductCodes.VISUAL_CPP_2008_SP1_REDIST_X64_KB2467174);
                    }
                }
            }
        }
    }

    public static void tryInstallDependencies(IProgressMonitor monitor) throws InstallException {
        ExecutionEnvironment env = ExecutionEnvironment.calculate();
        block0 : switch (env.os) {
            case WINDOWS: {
                switch (env.arch) {
                    case X86: {
                        ServerEnvironment.runInstaller(monitor, ProductCodes.VISUAL_CPP_2008_SP1_REDIST_X86_KB2467174, "VC90.2008.SP1.KB2467174.redist.x86.exe");
                        break block0;
                    }
                    case X86_64: {
                        ServerEnvironment.runInstaller(monitor, ProductCodes.VISUAL_CPP_2008_SP1_REDIST_X86_KB2467174, "VC90.2008.SP1.KB2467174.redist.x86.exe");
                        ServerEnvironment.runInstaller(monitor, ProductCodes.VISUAL_CPP_2008_SP1_REDIST_X64_KB2467174, "VC90.2008.SP1.KB2467174.redist.x64.exe");
                    }
                }
            }
        }
    }

    private static void runInstaller(IProgressMonitor monitor, Product product, String installerPath) throws InstallException {
        try {
            URL url = FileLocator.find((URL)new URL("platform:/plugin/org.simantics.db.procore.server.environment/" + installerPath));
            URL fileUrl = FileLocator.toFileURL((URL)url);
            File file = new File(fileUrl.getFile());
            System.out.println(file);
            Process installer = new ProcessBuilder("cmd.exe", "/C", file.toString(), "/qb").start();
            while (true) {
                try {
                    int exitValue = installer.exitValue();
                    switch (exitValue) {
                        case 0: {
                            return;
                        }
                        case 3010: {
                            throw new RebootRequiredException(Arrays.asList(product));
                        }
                    }
                    throw new InstallException("Installation of " + product.getDescription() + " failed with error code " + exitValue, Arrays.asList(product));
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            throw new InstallException(e, Arrays.asList(product));
        }
    }

    public static void main(String[] args) {
        try {
            ServerEnvironment.ensureServerDependenciesMet();
        }
        catch (ExecutionEnvironmentException e) {
            e.printStackTrace();
        }
    }
}

