/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.scl;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.scl.AbstractExpressionCompilationContext;
import org.simantics.db.layer0.scl.AbstractExpressionCompilationRequest;
import org.simantics.db.layer0.util.RuntimeEnvironmentRequest;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ComponentTypeSubstructure;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.constants.StringConstant;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.environment.Environments;
import org.simantics.scl.compiler.runtime.RuntimeEnvironment;
import org.simantics.scl.compiler.top.SCLExpressionCompilationException;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.utils.datastructures.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompileSCLMonitorRequest
extends AbstractExpressionCompilationRequest<CompilationContext, org.simantics.db.layer0.variable.Variable> {
    private static Logger LOGGER = LoggerFactory.getLogger(CompileSCLMonitorRequest.class);
    protected static Name BROWSE = Name.create((String)"Simantics/Variables", (String)"browse");
    protected static Name VALUE = Name.create((String)"Simantics/Variables", (String)"value");
    private final Resource componentType;
    private final Resource literal;
    private final Resource relation;

    private CompileSCLMonitorRequest(Resource componentType, Resource literal, Resource relation) {
        this.componentType = componentType;
        this.literal = literal;
        this.relation = relation;
    }

    public CompileSCLMonitorRequest(ReadGraph graph, org.simantics.db.layer0.variable.Variable context) throws DatabaseException {
        this(context.getParent(graph).getType(graph), context.getRepresents(graph), context.getPredicateResource(graph));
    }

    public static Object compileAndEvaluate(ReadGraph graph, org.simantics.db.layer0.variable.Variable context) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.get((Object)"graph");
        try {
            Function1 exp = (Function1)graph.syncRequest((Read)new CompileSCLMonitorRequest(graph, context), (Listener)TransientCacheListener.instance());
            sclContext.put((Object)"graph", (Object)graph);
            Object object = exp.apply((Object)context.getParent(graph));
            return object;
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new DatabaseException(t);
        }
        finally {
            sclContext.put((Object)"graph", oldGraph);
        }
    }

    protected String getExpressionText(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        return (String)graph.getRelatedValue(this.literal, L0.SCLValue_expression, (Binding)Bindings.STRING);
    }

    protected Type getExpectedType(ReadGraph graph, CompilationContext context) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        String valueType = (String)graph.getPossibleRelatedValue(this.relation, L0.RequiresValueType, (Binding)Bindings.STRING);
        if (valueType != null) {
            try {
                return Environments.getType((Environment)context.runtimeEnvironment.getEnvironment(), (String)valueType);
            }
            catch (SCLExpressionCompilationException e) {
                LOGGER.warn("getExpectedType failed for valueType: " + valueType, (Throwable)e);
            }
        }
        return super.getExpectedType(graph, (AbstractExpressionCompilationContext)context);
    }

    protected CompilationContext getCompilationContext(ReadGraph graph) throws DatabaseException {
        return (CompilationContext)((Object)graph.syncRequest((Read)new ResourceRead<CompilationContext>(this.componentType){

            public CompilationContext perform(ReadGraph graph) throws DatabaseException {
                Resource indexRoot = (Resource)graph.syncRequest((Read)new IndexRoot(this.resource));
                RuntimeEnvironment runtimeEnvironment = (RuntimeEnvironment)graph.syncRequest((Read)new RuntimeEnvironmentRequest(indexRoot));
                return new CompilationContext(runtimeEnvironment, ComponentTypeSubstructure.forType((RequestProcessor)graph, this.resource));
            }
        }));
    }

    protected Type getContextVariableType() {
        return VARIABLE;
    }

    protected Expression getVariableAccessExpression(ReadGraph graph, CompilationContext context, Variable contextVariable, String name) throws DatabaseException {
        Pair<String, Type> entry = context.substructure.possibleTypedRVI(name);
        if (entry == null) {
            return null;
        }
        Environment environment = context.runtimeEnvironment.getEnvironment();
        EApply propertyVariable = new EApply((Expression)new EConstant(environment.getValue(BROWSE)), new Expression[]{new EVariable(contextVariable), new ELiteral((Constant)new StringConstant((String)entry.first))});
        return CompileSCLMonitorRequest.makeTypeFlexible((Environment)environment, (Expression)new EApply((Expression)new EConstant(environment.getValue(VALUE), new Type[]{(Type)entry.second}), (Expression)propertyVariable), (Type)((Type)entry.second));
    }

    public int hashCode() {
        return 31 * (31 * ((Object)((Object)this)).getClass().hashCode() + this.literal.hashCode()) + this.componentType.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        CompileSCLMonitorRequest other = (CompileSCLMonitorRequest)((Object)obj);
        return this.literal.equals(other.literal) && this.componentType.equals(other.componentType);
    }

    public static class CompilationContext
    extends AbstractExpressionCompilationContext {
        public final ComponentTypeSubstructure substructure;

        public CompilationContext(RuntimeEnvironment runtimeEnvironment, ComponentTypeSubstructure substructure) {
            super(runtimeEnvironment);
            this.substructure = substructure;
        }
    }
}

