/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.SessionImplSocket;
import java.util.HashSet;
import java.util.Set;
import org.simantics.db.ReadGraph;
import org.simantics.db.service.ClusterCollectorPolicy;
import org.simantics.db.service.ClusterControl;

public class ClusterControlImpl
implements ClusterControl {
    private final SessionImplSocket session;

    ClusterControlImpl(SessionImplSocket session) {
        this.session = session;
    }

    public ClusterCollectorPolicy setPolicy(ClusterCollectorPolicy newPolicy) {
        return this.session.clusterTable.collector.setPolicy(newPolicy);
    }

    public int flushClusters() {
        this.session.clusterTable.gc();
        System.gc();
        System.gc();
        return this.session.clusterTable.size();
    }

    public int collectClusters(int desiredBytes) {
        this.session.clusterTable.collector.collect(desiredBytes);
        return 0;
    }

    public int gc(ReadGraph graph) {
        this.session.clusterTable.collector.collect();
        return 0;
    }

    public int gc(ReadGraph graph, int objectiveBytes) {
        if (objectiveBytes < 0) {
            return this.gc(graph);
        }
        if (objectiveBytes > this.used()) {
            return 0;
        }
        this.session.clusterTable.collector.collect(this.used() - objectiveBytes);
        return 0;
    }

    public ClusterControl.ClusterState getClusterState() {
        return this.session.clusterTable.getState();
    }

    public void restoreClusterState(ClusterControl.ClusterState state) {
        this.session.clusterTable.restoreState((ClusterStateImpl)state);
    }

    public int used() {
        return (int)this.session.clusterTable.getSizeInBytes();
    }

    static class ClusterStateImpl
    implements ClusterControl.ClusterState {
        public Set<ClusterCollectorPolicy.CollectorCluster> ids = new HashSet<ClusterCollectorPolicy.CollectorCluster>();

        ClusterStateImpl() {
        }
    }
}

